/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.security;

import java.io.Serializable;
import java.net.URI;
import org.gwe.utils.security.AccountInfo;

public class URILink
implements Serializable {
    private AccountInfo account;
    private URI uri;

    public static URILink createLocalLink(URI uriObj) {
        return new URILink(AccountInfo.createLocalAccount(), uriObj);
    }

    public URILink(AccountInfo account, URI uri) {
        this.account = account;
        this.uri = uri;
    }

    public AccountInfo getAccountInfo() {
        return this.account;
    }

    public URI getURI() {
        return this.uri;
    }

    public String createFSURI(String path) {
        return this.uri == null || this.uri.getHost() == null || this.uri.getHost().equals("") || this.uri.getHost().equals("localhost") ? "file://" + path : "sftp://" + this.uri.getHost() + path;
    }

    public String toString() {
        String accountName = this.account != null ? this.account.getAccountName() : "NONE";
        return "[" + accountName + "]@[" + this.uri + "]";
    }
}

