/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.utils.services.PlainService;
import org.gwe.utils.services.ProcessingPermitBroker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokeredService<RETURN_TYPE> {
    private static Log log = LogFactory.getLog(BrokeredService.class);
    protected ProcessingPermitBroker mgr;
    private String name;

    public BrokeredService(String name) {
        this(5, name);
    }

    public BrokeredService(int maxParallelRequest, String name) {
        this.mgr = new ProcessingPermitBroker(maxParallelRequest, name);
        this.name = name;
    }

    public final String getServiceName() {
        return this.name;
    }

    public final RETURN_TYPE processRequestBlocking(PlainService<RETURN_TYPE> service) throws Exception {
        long reqId = this.mgr.createPermit();
        log.info("Permit [" + reqId + "] issued to process service [" + service + "]");
        try {
            RETURN_TYPE result = service.runService();
            this.mgr.destroyPermit(reqId);
            return result;
        }
        catch (Exception e) {
            this.mgr.destroyPermit(reqId);
            log.warn("Exception encountered while trying to process a brokered service", e);
            throw e;
        }
    }
}

