/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.utils.services.PermitRequest;

public class ProcessingPermitBroker
implements Runnable {
    private static Log log = LogFactory.getLog(ProcessingPermitBroker.class);
    private List<PermitRequest> pendingRequests = new ArrayList<PermitRequest>();
    private Map<Long, PermitRequest> processingRequests = new TreeMap<Long, PermitRequest>();
    private Map<Long, PermitRequest> completedRequests = new TreeMap<Long, PermitRequest>();
    private int maxParallel;

    public ProcessingPermitBroker(String name) {
        this(0, name);
    }

    public ProcessingPermitBroker(int maxParallelRequest, String name) {
        this.maxParallel = maxParallelRequest;
        Thread brokerThread = new Thread((Runnable)this, name + " Permit's Broker");
        brokerThread.setDaemon(true);
        brokerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            if (this.pendingRequests.size() == 0 || this.maxParallel > 0 && this.processingRequests.size() >= this.maxParallel) {
                try {
                    log.info("Manager thread is going to sleep...");
                    this.wait();
                    log.info("Manager thread woke up!");
                }
                catch (InterruptedException e) {}
                continue;
            }
            PermitRequest handle = this.pendingRequests.remove(0);
            log.info("Manager is granting permission to request [" + handle + "]");
            this.processingRequests.put(handle.getId(), handle);
            Object object = handle.getLock();
            synchronized (object) {
                handle.getLock().notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createPermit() {
        log.info("Client is soliciting processing permit");
        PermitRequest handle = PermitRequest.createDescriptor();
        Object object = handle.getLock();
        synchronized (object) {
            try {
                this.addHandle(handle);
                handle.getLock().wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        log.info("Client has been granted processing permission for request [" + handle + "]");
        return handle.getId();
    }

    private synchronized void addHandle(PermitRequest handle) {
        log.info("Adding request [" + handle + "] to waiting queue. Waking up manager thread...");
        this.pendingRequests.add(handle);
        this.notifyAll();
    }

    public synchronized void destroyPermit(long reqId) {
        PermitRequest handle = this.processingRequests.remove(reqId);
        log.info("Client is reporting that is done with permit [" + handle + "]. Waking up manager thread...");
        this.completedRequests.put(handle.getId(), handle);
        this.notifyAll();
    }
}

