/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.IdentityMap;

public class DefaultMergeEventListener
extends AbstractSaveEventListener
implements MergeEventListener {
    private static final Log log = LogFactory.getLog(DefaultMergeEventListener.class);

    protected Map getMergeMap(Object anything) {
        return IdentityMap.invert((Map)anything);
    }

    public void onMerge(MergeEvent event) throws HibernateException {
        this.onMerge(event, IdentityMap.instantiate(10));
    }

    public void onMerge(MergeEvent event, Map copyCache) throws HibernateException {
        EventSource source = event.getSession();
        Object original = event.getOriginal();
        if (original != null) {
            Object entity;
            if (original instanceof HibernateProxy) {
                LazyInitializer li = ((HibernateProxy)original).getHibernateLazyInitializer();
                if (li.isUninitialized()) {
                    log.trace("ignoring uninitialized proxy");
                    event.setResult(source.load(li.getEntityName(), li.getIdentifier()));
                    return;
                }
                entity = li.getImplementation();
            } else {
                entity = original;
            }
            if (copyCache.containsKey(entity)) {
                log.trace("already merged");
                event.setResult(entity);
            } else {
                EntityPersister persister;
                Serializable id;
                event.setEntity(entity);
                int entityState = -1;
                EntityEntry entry = source.getPersistenceContext().getEntry(entity);
                if (entry == null && (id = (persister = source.getEntityPersister(event.getEntityName(), entity)).getIdentifier(entity, source.getEntityMode())) != null) {
                    EntityKey key = new EntityKey(id, persister, source.getEntityMode());
                    Object managedEntity = source.getPersistenceContext().getEntity(key);
                    entry = source.getPersistenceContext().getEntry(managedEntity);
                    if (entry != null) {
                        entityState = 2;
                    }
                }
                if (entityState == -1) {
                    entityState = this.getEntityState(entity, event.getEntityName(), entry, source);
                }
                switch (entityState) {
                    case 2: {
                        this.entityIsDetached(event, copyCache);
                        break;
                    }
                    case 1: {
                        this.entityIsTransient(event, copyCache);
                        break;
                    }
                    case 0: {
                        this.entityIsPersistent(event, copyCache);
                        break;
                    }
                    default: {
                        throw new ObjectDeletedException("deleted instance passed to merge", null, this.getLoggableName(event.getEntityName(), entity));
                    }
                }
            }
        }
    }

    protected void entityIsPersistent(MergeEvent event, Map copyCache) {
        log.trace("ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        copyCache.put(entity, entity);
        this.cascadeOnMerge(source, persister, entity, copyCache);
        this.copyValues(persister, entity, entity, source, copyCache);
        event.setResult(entity);
    }

    protected void entityIsTransient(MergeEvent event, Map copyCache) {
        log.trace("merging transient instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        Serializable id = persister.hasIdentifierProperty() ? persister.getIdentifier(entity, source.getEntityMode()) : null;
        Object copy = persister.instantiate(id, source.getEntityMode());
        copyCache.put(entity, copy);
        super.cascadeBeforeSave(source, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, source, copyCache, ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT);
        Serializable requestedId = event.getRequestedId();
        if (requestedId == null) {
            this.saveWithGeneratedId(copy, entityName, copyCache, source, false);
        } else {
            this.saveWithRequestedId(copy, requestedId, entityName, copyCache, source);
        }
        super.cascadeAfterSave(source, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, source, copyCache, ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        event.setResult(copy);
    }

    protected void entityIsDetached(MergeEvent event, Map copyCache) {
        log.trace("merging detached instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        Serializable id = event.getRequestedId();
        if (id == null) {
            id = persister.getIdentifier(entity, source.getEntityMode());
        } else {
            Serializable entityId = persister.getIdentifier(entity, source.getEntityMode());
            if (!persister.getIdentifierType().isEqual(id, entityId, source.getEntityMode(), source.getFactory())) {
                throw new HibernateException("merge requested with id not matching id of passed entity");
            }
        }
        String previousFetchProfile = source.getFetchProfile();
        source.setFetchProfile("merge");
        Serializable clonedIdentifier = (Serializable)persister.getIdentifierType().deepCopy(id, source.getEntityMode(), source.getFactory());
        Object result = source.get(entityName, clonedIdentifier);
        source.setFetchProfile(previousFetchProfile);
        if (result == null) {
            this.entityIsTransient(event, copyCache);
        } else {
            copyCache.put(entity, result);
            Object target = source.getPersistenceContext().unproxy(result);
            if (target == entity) {
                throw new AssertionFailure("entity was not detached");
            }
            if (!source.getEntityName(target).equals(entityName)) {
                throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
            }
            if (this.isVersionChanged(entity, source, persister, target)) {
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().optimisticFailure(entityName);
                }
                throw new StaleObjectStateException(entityName, id);
            }
            this.cascadeOnMerge(source, persister, entity, copyCache);
            this.copyValues(persister, entity, target, source, copyCache);
            this.markInterceptorDirty(entity, target);
            event.setResult(result);
        }
    }

    private void markInterceptorDirty(Object entity, Object target) {
        FieldInterceptor interceptor;
        if (FieldInterceptionHelper.isInstrumented(entity) && (interceptor = FieldInterceptionHelper.extractFieldInterceptor(target)) != null) {
            interceptor.dirty();
        }
    }

    private boolean isVersionChanged(Object entity, EventSource source, EntityPersister persister, Object target) {
        if (!persister.isVersioned()) {
            return false;
        }
        boolean changed = !persister.getVersionType().isSame(persister.getVersion(target, source.getEntityMode()), persister.getVersion(entity, source.getEntityMode()), source.getEntityMode());
        return changed && this.existsInDatabase(target, source, persister);
    }

    private boolean existsInDatabase(Object entity, EventSource source, EntityPersister persister) {
        Serializable id;
        EntityEntry entry = source.getPersistenceContext().getEntry(entity);
        if (entry == null && (id = persister.getIdentifier(entity, source.getEntityMode())) != null) {
            EntityKey key = new EntityKey(id, persister, source.getEntityMode());
            Object managedEntity = source.getPersistenceContext().getEntity(key);
            entry = source.getPersistenceContext().getEntry(managedEntity);
        }
        if (entry == null) {
            return false;
        }
        return entry.isExistsInDatabase();
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache) {
        Object[] copiedValues = TypeFactory.replace(persister.getPropertyValues(entity, source.getEntityMode()), persister.getPropertyValues(target, source.getEntityMode()), persister.getPropertyTypes(), source, target, copyCache);
        persister.setPropertyValues(target, copiedValues, source.getEntityMode());
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copiedValues = foreignKeyDirection == ForeignKeyDirection.FOREIGN_KEY_TO_PARENT ? TypeFactory.replaceAssociations(persister.getPropertyValues(entity, source.getEntityMode()), persister.getPropertyValues(target, source.getEntityMode()), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection) : TypeFactory.replace(persister.getPropertyValues(entity, source.getEntityMode()), persister.getPropertyValues(target, source.getEntityMode()), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection);
        persister.setPropertyValues(target, copiedValues, source.getEntityMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource source, EntityPersister persister, Object entity, Map copyCache) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 0, source).cascade(persister, entity, copyCache);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.MERGE;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.FALSE;
    }

    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
    }

    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
    }
}

