/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.SemanticException;
import antlr.collections.AST;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.InvalidPathException;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.IdentNode;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.LiteralType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;

public class LiteralProcessor
implements HqlSqlTokenTypes {
    public static final int EXACT = 0;
    public static final int APPROXIMATE = 1;
    public static int DECIMAL_LITERAL_FORMAT = 0;
    private static final Log log = LogFactory.getLog(LiteralProcessor.class);
    private HqlSqlWalker walker;
    private static final DecimalFormatter[] formatters = new DecimalFormatter[]{new ExactDecimalFormatter(), new ApproximateDecimalFormatter()};

    public LiteralProcessor(HqlSqlWalker hqlSqlWalker) {
        this.walker = hqlSqlWalker;
    }

    public boolean isAlias(String alias) {
        FromClause from = this.walker.getCurrentFromClause();
        while (from.isSubQuery()) {
            if (from.containsClassAlias(alias)) {
                return true;
            }
            from = from.getParentFromClause();
        }
        return from.containsClassAlias(alias);
    }

    public void processConstant(AST constant, boolean resolveIdent) throws SemanticException {
        boolean isIdent;
        boolean bl = isIdent = constant.getType() == 120 || constant.getType() == 90;
        if (resolveIdent && isIdent && this.isAlias(constant.getText())) {
            IdentNode ident = (IdentNode)constant;
            ident.resolve(false, true);
        } else {
            Queryable queryable = this.walker.getSessionFactoryHelper().findQueryableUsingImports(constant.getText());
            if (isIdent && queryable != null) {
                constant.setText(queryable.getDiscriminatorSQLValue());
            } else {
                this.processLiteral(constant);
            }
        }
    }

    public void lookupConstant(DotNode node) throws SemanticException {
        String text = this.getText(node);
        Queryable persister = this.walker.getSessionFactoryHelper().findQueryableUsingImports(text);
        if (persister != null) {
            String discrim = persister.getDiscriminatorSQLValue();
            if ("null".equals(discrim) || "not null".equals(discrim)) {
                throw new InvalidPathException("subclass test not allowed for null or not null discriminator: '" + text + "'");
            }
            this.setSQLValue(node, text, discrim);
        } else {
            Object value = ReflectHelper.getConstantValue(text);
            if (value == null) {
                throw new InvalidPathException("Invalid path: '" + text + "'");
            }
            this.setConstantValue(node, text, value);
        }
    }

    private void setSQLValue(DotNode node, String text, String value) {
        if (log.isDebugEnabled()) {
            log.debug("setSQLValue() " + text + " -> " + value);
        }
        node.setFirstChild(null);
        node.setType(136);
        node.setText(value);
        node.setResolvedConstant(text);
    }

    private void setConstantValue(DotNode node, String text, Object value) {
        Type type;
        if (log.isDebugEnabled()) {
            log.debug("setConstantValue() " + text + " -> " + value + " " + value.getClass().getName());
        }
        node.setFirstChild(null);
        if (value instanceof String) {
            node.setType(119);
        } else if (value instanceof Character) {
            node.setType(119);
        } else if (value instanceof Byte) {
            node.setType(118);
        } else if (value instanceof Short) {
            node.setType(118);
        } else if (value instanceof Integer) {
            node.setType(118);
        } else if (value instanceof Long) {
            node.setType(94);
        } else if (value instanceof Double) {
            node.setType(92);
        } else if (value instanceof Float) {
            node.setType(93);
        } else {
            node.setType(91);
        }
        try {
            type = TypeFactory.heuristicType(value.getClass().getName());
        }
        catch (MappingException me) {
            throw new QueryException(me);
        }
        if (type == null) {
            throw new QueryException("Could not determine type of: " + node.getText());
        }
        try {
            LiteralType literalType = (LiteralType)((Object)type);
            Dialect dialect = this.walker.getSessionFactoryHelper().getFactory().getDialect();
            node.setText(literalType.objectToSQLString(value, dialect));
        }
        catch (Exception e) {
            throw new QueryException("Could not format constant value to SQL literal: " + node.getText(), e);
        }
        node.setDataType(type);
        node.setResolvedConstant(text);
    }

    private String getText(AST node) {
        return ASTUtil.getPathText(node);
    }

    public void processBoolean(AST constant) {
        String replacement = (String)this.walker.getTokenReplacements().get(constant.getText());
        if (replacement != null) {
            constant.setText(replacement);
        } else {
            boolean bool = "true".equals(constant.getText().toLowerCase());
            Dialect dialect = this.walker.getSessionFactoryHelper().getFactory().getDialect();
            constant.setText(dialect.toBooleanValueString(bool));
        }
    }

    private void processLiteral(AST constant) {
        String replacement = (String)this.walker.getTokenReplacements().get(constant.getText());
        if (replacement != null) {
            if (log.isDebugEnabled()) {
                log.debug("processConstant() : Replacing '" + constant.getText() + "' with '" + replacement + "'");
            }
            constant.setText(replacement);
        }
    }

    public void processNumeric(AST literal) {
        if (literal.getType() == 118 || literal.getType() == 94) {
            literal.setText(this.determineIntegerRepresentation(literal.getText(), literal.getType()));
        } else if (literal.getType() == 93 || literal.getType() == 92) {
            literal.setText(this.determineDecimalRepresentation(literal.getText(), literal.getType()));
        } else {
            log.warn("Unexpected literal token type [" + literal.getType() + "] passed for numeric processing");
        }
    }

    private String determineIntegerRepresentation(String text, int type) {
        try {
            String literalValue;
            if (type == 118) {
                try {
                    return Integer.valueOf(text).toString();
                }
                catch (NumberFormatException e) {
                    log.trace("could not format incoming text [" + text + "] as a NUM_INT; assuming numeric overflow and attempting as NUM_LONG");
                }
            }
            if ((literalValue = text).endsWith("l") || literalValue.endsWith("L")) {
                literalValue = literalValue.substring(0, literalValue.length() - 1);
            }
            return Long.valueOf(literalValue).toString();
        }
        catch (Throwable t) {
            throw new HibernateException("Could not parse literal [" + text + "] as integer", t);
        }
    }

    public String determineDecimalRepresentation(String text, int type) {
        String literalValue = text;
        if (type == 93) {
            if (literalValue.endsWith("f") || literalValue.endsWith("F")) {
                literalValue = literalValue.substring(0, literalValue.length() - 1);
            }
        } else if (type == 92 && (literalValue.endsWith("d") || literalValue.endsWith("D"))) {
            literalValue = literalValue.substring(0, literalValue.length() - 1);
        }
        BigDecimal number = null;
        try {
            number = new BigDecimal(literalValue);
        }
        catch (Throwable t) {
            throw new HibernateException("Could not parse literal [" + text + "] as big-decimal", t);
        }
        return formatters[DECIMAL_LITERAL_FORMAT].format(number);
    }

    private static class ApproximateDecimalFormatter
    implements DecimalFormatter {
        private static final String FORMAT_STRING = "#0.0E0";

        private ApproximateDecimalFormatter() {
        }

        public String format(BigDecimal number) {
            try {
                DecimalFormat jdkFormatter = new DecimalFormat(FORMAT_STRING);
                jdkFormatter.setMinimumIntegerDigits(1);
                jdkFormatter.setMaximumFractionDigits(Integer.MAX_VALUE);
                return jdkFormatter.format(number);
            }
            catch (Throwable t) {
                throw new HibernateException("Unable to format decimal literal in approximate format [" + number.toString() + "]", t);
            }
        }
    }

    private static class ExactDecimalFormatter
    implements DecimalFormatter {
        private ExactDecimalFormatter() {
        }

        public String format(BigDecimal number) {
            return number.toString();
        }
    }

    private static interface DecimalFormatter {
        public String format(BigDecimal var1);
    }
}

