/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.TableGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class TableHiLoGenerator
extends TableGenerator {
    public static final String MAX_LO = "max_lo";
    private long hi;
    private int lo;
    private int maxLo;
    private Class returnClass;
    private static final Log log = LogFactory.getLog(TableHiLoGenerator.class);

    public void configure(Type type, Properties params, Dialect d) {
        super.configure(type, params, d);
        this.maxLo = PropertiesHelper.getInt(MAX_LO, params, Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        if (this.maxLo < 1) {
            int val = (Integer)super.generate(session, obj);
            return IdentifierGeneratorFactory.createNumber(val, this.returnClass);
        }
        if (this.lo > this.maxLo) {
            int hival = (Integer)super.generate(session, obj);
            this.lo = hival == 0 ? 1 : 0;
            this.hi = hival * (this.maxLo + 1);
            log.debug("new hi value: " + hival);
        }
        return IdentifierGeneratorFactory.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }
}

