/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;

public class AspectJWeaverMessageHandler
implements IMessageHandler {
    private static final String AJ_ID = "[AspectJ] ";
    private static final Log logger = LogFactory.getLog("AspectJ Weaver");

    public boolean handleMessage(IMessage message) throws AbortException {
        IMessage.Kind messageKind = message.getKind();
        if ((logger.isDebugEnabled() || logger.isTraceEnabled()) && messageKind == IMessage.DEBUG) {
            logger.debug(this.makeMessageFor(message));
            return true;
        }
        if (logger.isInfoEnabled() && (messageKind == IMessage.INFO || messageKind == IMessage.WEAVEINFO)) {
            logger.info(this.makeMessageFor(message));
            return true;
        }
        if (logger.isWarnEnabled() && messageKind == IMessage.WARNING) {
            logger.warn(this.makeMessageFor(message));
            return true;
        }
        if (logger.isErrorEnabled() && messageKind == IMessage.ERROR) {
            logger.error(this.makeMessageFor(message));
            return true;
        }
        if (logger.isFatalEnabled() && messageKind == IMessage.ABORT) {
            logger.fatal(this.makeMessageFor(message));
            return true;
        }
        return false;
    }

    private String makeMessageFor(IMessage aMessage) {
        return AJ_ID + aMessage.getMessage();
    }

    public boolean isIgnoring(IMessage.Kind messageKind) {
        return false;
    }

    public void dontIgnore(IMessage.Kind messageKind) {
    }

    public void ignore(IMessage.Kind kind) {
    }
}

