/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.beans.factory.NamedBean;

public abstract class ExposeBeanNameAdvisors {
    private static final String BEAN_NAME_ATTRIBUTE = (class$org$springframework$aop$interceptor$ExposeBeanNameAdvisors == null ? (class$org$springframework$aop$interceptor$ExposeBeanNameAdvisors = ExposeBeanNameAdvisors.class$("org.springframework.aop.interceptor.ExposeBeanNameAdvisors")) : class$org$springframework$aop$interceptor$ExposeBeanNameAdvisors).getName() + ".beanName";
    static /* synthetic */ Class class$org$springframework$aop$interceptor$ExposeBeanNameAdvisors;

    public static String getBeanName() throws IllegalStateException {
        MethodInvocation mi = ExposeInvocationInterceptor.currentInvocation();
        return ExposeBeanNameAdvisors.getBeanName(mi);
    }

    public static String getBeanName(MethodInvocation mi) throws IllegalStateException {
        if (!(mi instanceof ReflectiveMethodInvocation)) {
            throw new IllegalArgumentException("Not a Spring AOP ReflectiveMethodInvocation");
        }
        ReflectiveMethodInvocation rmi = (ReflectiveMethodInvocation)mi;
        String beanName = (String)rmi.getUserAttribute(BEAN_NAME_ATTRIBUTE);
        if (beanName == null) {
            throw new IllegalStateException("Cannot get bean name: not set on MethodInvocation. Include ExposeBeanNameAdvisor in interceptor chain.");
        }
        return beanName;
    }

    public static Advisor createAdvisorWithoutIntroduction(String beanName) {
        return new DefaultPointcutAdvisor(new ExposeBeanNameInterceptor(beanName));
    }

    public static Advisor createAdvisorIntroducingNamedBean(String beanName) {
        return new DefaultIntroductionAdvisor(new ExposeBeanNameIntroduction(beanName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ExposeBeanNameIntroduction
    extends DelegatingIntroductionInterceptor
    implements NamedBean {
        private final String beanName;

        public ExposeBeanNameIntroduction(String beanName) {
            this.beanName = beanName;
        }

        public Object invoke(MethodInvocation mi) throws Throwable {
            ReflectiveMethodInvocation rmi = (ReflectiveMethodInvocation)mi;
            rmi.setUserAttribute(BEAN_NAME_ATTRIBUTE, this.beanName);
            return super.invoke(mi);
        }

        public String getBeanName() {
            return this.beanName;
        }
    }

    private static class ExposeBeanNameInterceptor
    implements MethodInterceptor {
        private final String beanName;

        public ExposeBeanNameInterceptor(String beanName) {
            this.beanName = beanName;
        }

        public Object invoke(MethodInvocation mi) throws Throwable {
            ReflectiveMethodInvocation rmi = (ReflectiveMethodInvocation)mi;
            rmi.setUserAttribute(BEAN_NAME_ATTRIBUTE, this.beanName);
            return mi.proceed();
        }
    }
}

