/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.util.Assert;

public class AnnotationBeanWiringInfoResolver
implements BeanWiringInfoResolver {
    private static final String CGLIB_MAGIC = "EnhancerByCGLIB";

    public BeanWiringInfo resolveWiringInfo(Object beanInstance) {
        Assert.notNull(beanInstance, "Bean instance must not be null");
        Class<?> clazz = beanInstance.getClass();
        Configurable configurableAnnotation = clazz.getAnnotation(Configurable.class);
        if (configurableAnnotation != null) {
            if (!Autowire.NO.equals((Object)configurableAnnotation.autowire())) {
                return new BeanWiringInfo(configurableAnnotation.autowire().value(), configurableAnnotation.dependencyCheck());
            }
            String beanName = "".equals(configurableAnnotation.value()) ? this.getUserClassName(clazz) : configurableAnnotation.value();
            return new BeanWiringInfo(beanName);
        }
        return null;
    }

    private String getUserClassName(Class beanClass) {
        String className = beanClass.getName();
        if (className.indexOf(CGLIB_MAGIC) != -1) {
            className = beanClass.getSuperclass().getName();
        }
        return className;
    }
}

