/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.lob.AbstractLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;

public class DefaultLobHandler
extends AbstractLobHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public byte[] getBlobAsBytes(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning BLOB as bytes");
        return rs.getBytes(columnIndex);
    }

    public InputStream getBlobAsBinaryStream(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning BLOB as binary stream");
        return rs.getBinaryStream(columnIndex);
    }

    public String getClobAsString(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning CLOB as string");
        return rs.getString(columnIndex);
    }

    public InputStream getClobAsAsciiStream(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning CLOB as ASCII stream");
        return rs.getAsciiStream(columnIndex);
    }

    public Reader getClobAsCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning CLOB as character stream");
        return rs.getCharacterStream(columnIndex);
    }

    public LobCreator getLobCreator() {
        this.logger.debug("Creating new DefaultLobCreator");
        return new DefaultLobCreator();
    }

    protected class DefaultLobCreator
    implements LobCreator {
        protected DefaultLobCreator() {
        }

        public void setBlobAsBytes(PreparedStatement ps, int paramIndex, byte[] content) throws SQLException {
            ps.setBytes(paramIndex, content);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(content != null ? "Set bytes for BLOB with length " + content.length : "Set BLOB to null");
            }
        }

        public void setBlobAsBinaryStream(PreparedStatement ps, int paramIndex, InputStream binaryStream, int contentLength) throws SQLException {
            ps.setBinaryStream(paramIndex, binaryStream, contentLength);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(binaryStream != null ? "Set binary stream for BLOB with length " + contentLength : "Set BLOB to null");
            }
        }

        public void setClobAsString(PreparedStatement ps, int paramIndex, String content) throws SQLException {
            ps.setString(paramIndex, content);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(content != null ? "Set string for CLOB with length " + content.length() : "Set CLOB to null");
            }
        }

        public void setClobAsAsciiStream(PreparedStatement ps, int paramIndex, InputStream asciiStream, int contentLength) throws SQLException {
            ps.setAsciiStream(paramIndex, asciiStream, contentLength);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(asciiStream != null ? "Set ASCII stream for CLOB with length " + contentLength : "Set CLOB to null");
            }
        }

        public void setClobAsCharacterStream(PreparedStatement ps, int paramIndex, Reader characterStream, int contentLength) throws SQLException {
            ps.setCharacterStream(paramIndex, characterStream, contentLength);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug(characterStream != null ? "Set character stream for CLOB with length " + contentLength : "Set CLOB to null");
            }
        }

        public void close() {
            DefaultLobHandler.this.logger.debug("Closing DefaultLobCreator");
        }
    }
}

