/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.io.File;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.event.EventListeners;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate3.AbstractSessionFactoryBean;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.TypeDefinitionBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LocalSessionFactoryBean
extends AbstractSessionFactoryBean {
    private static final ThreadLocal configTimeDataSourceHolder = new ThreadLocal();
    private static final ThreadLocal configTimeTransactionManagerHolder = new ThreadLocal();
    private static final ThreadLocal configTimeLobHandlerHolder = new ThreadLocal();
    private Class configurationClass = class$org$hibernate$cfg$Configuration == null ? (class$org$hibernate$cfg$Configuration = LocalSessionFactoryBean.class$("org.hibernate.cfg.Configuration")) : class$org$hibernate$cfg$Configuration;
    private Resource[] configLocations;
    private Resource[] mappingLocations;
    private Resource[] cacheableMappingLocations;
    private Resource[] mappingJarLocations;
    private Resource[] mappingDirectoryLocations;
    private Properties hibernateProperties;
    private DataSource dataSource;
    private boolean useTransactionAwareDataSource = false;
    private TransactionManager jtaTransactionManager;
    private LobHandler lobHandler;
    private Interceptor entityInterceptor;
    private NamingStrategy namingStrategy;
    private TypeDefinitionBean[] typeDefinitions;
    private FilterDefinition[] filterDefinitions;
    private Properties entityCacheStrategies;
    private Properties collectionCacheStrategies;
    private Map eventListeners;
    private boolean schemaUpdate = false;
    private Configuration configuration;
    static /* synthetic */ Class class$org$hibernate$cfg$Configuration;
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$LocalTransactionManagerLookup;
    static /* synthetic */ Class class$org$hibernate$transaction$JTATransactionFactory;
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$TransactionAwareDataSourceConnectionProvider;
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$LocalDataSourceConnectionProvider;

    public static DataSource getConfigTimeDataSource() {
        return (DataSource)configTimeDataSourceHolder.get();
    }

    public static TransactionManager getConfigTimeTransactionManager() {
        return (TransactionManager)configTimeTransactionManagerHolder.get();
    }

    public static LobHandler getConfigTimeLobHandler() {
        return (LobHandler)configTimeLobHandlerHolder.get();
    }

    public void setConfigurationClass(Class configurationClass) {
        if (configurationClass == null || !(class$org$hibernate$cfg$Configuration == null ? (class$org$hibernate$cfg$Configuration = LocalSessionFactoryBean.class$("org.hibernate.cfg.Configuration")) : class$org$hibernate$cfg$Configuration).isAssignableFrom(configurationClass)) {
            throw new IllegalArgumentException("configurationClass must be assignable to [org.hibernate.cfg.Configuration]");
        }
        this.configurationClass = configurationClass;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocations = new Resource[]{configLocation};
    }

    public void setConfigLocations(Resource[] configLocations) {
        this.configLocations = configLocations;
    }

    public void setMappingResources(String[] mappingResources) {
        this.mappingLocations = new Resource[mappingResources.length];
        for (int i = 0; i < mappingResources.length; ++i) {
            this.mappingLocations[i] = new ClassPathResource(mappingResources[i].trim());
        }
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void setCacheableMappingLocations(Resource[] cacheableMappingLocations) {
        this.cacheableMappingLocations = cacheableMappingLocations;
    }

    public void setMappingJarLocations(Resource[] mappingJarLocations) {
        this.mappingJarLocations = mappingJarLocations;
    }

    public void setMappingDirectoryLocations(Resource[] mappingDirectoryLocations) {
        this.mappingDirectoryLocations = mappingDirectoryLocations;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public Properties getHibernateProperties() {
        if (this.hibernateProperties == null) {
            this.hibernateProperties = new Properties();
        }
        return this.hibernateProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setUseTransactionAwareDataSource(boolean useTransactionAwareDataSource) {
        this.useTransactionAwareDataSource = useTransactionAwareDataSource;
    }

    public void setJtaTransactionManager(TransactionManager jtaTransactionManager) {
        this.jtaTransactionManager = jtaTransactionManager;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setTypeDefinitions(TypeDefinitionBean[] typeDefinitions) {
        this.typeDefinitions = typeDefinitions;
    }

    public void setFilterDefinitions(FilterDefinition[] filterDefinitions) {
        this.filterDefinitions = filterDefinitions;
    }

    public void setEntityCacheStrategies(Properties entityCacheStrategies) {
        this.entityCacheStrategies = entityCacheStrategies;
    }

    public void setCollectionCacheStrategies(Properties collectionCacheStrategies) {
        this.collectionCacheStrategies = collectionCacheStrategies;
    }

    public void setEventListeners(Map eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void setSchemaUpdate(boolean schemaUpdate) {
        this.schemaUpdate = schemaUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionFactory buildSessionFactory() throws Exception {
        Configuration config = this.newConfiguration();
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        if (this.jtaTransactionManager != null) {
            configTimeTransactionManagerHolder.set(this.jtaTransactionManager);
        }
        if (this.lobHandler != null) {
            configTimeLobHandlerHolder.set(this.lobHandler);
        }
        try {
            String[] strategyAndRegion;
            if (this.jtaTransactionManager != null) {
                config.setProperty("hibernate.transaction.manager_lookup_class", (class$org$springframework$orm$hibernate3$LocalTransactionManagerLookup == null ? (class$org$springframework$orm$hibernate3$LocalTransactionManagerLookup = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate3.LocalTransactionManagerLookup")) : class$org$springframework$orm$hibernate3$LocalTransactionManagerLookup).getName());
                config.setProperty("hibernate.transaction.factory_class", (class$org$hibernate$transaction$JTATransactionFactory == null ? (class$org$hibernate$transaction$JTATransactionFactory = LocalSessionFactoryBean.class$("org.hibernate.transaction.JTATransactionFactory")) : class$org$hibernate$transaction$JTATransactionFactory).getName());
            } else {
                config.setProperty("hibernate.connection.release_mode", ConnectionReleaseMode.ON_CLOSE.toString());
            }
            if (!this.isExposeTransactionAwareSessionFactory()) {
                config.setProperty("hibernate.current_session_context_class", "org.springframework.orm.hibernate3.SpringSessionContext");
            }
            if (this.entityInterceptor != null) {
                config.setInterceptor(this.entityInterceptor);
            }
            if (this.namingStrategy != null) {
                config.setNamingStrategy(this.namingStrategy);
            }
            if (this.typeDefinitions != null) {
                Mappings mappings = config.createMappings();
                for (int i = 0; i < this.typeDefinitions.length; ++i) {
                    TypeDefinitionBean typeDef = this.typeDefinitions[i];
                    mappings.addTypeDef(typeDef.getTypeName(), typeDef.getTypeClass(), typeDef.getParameters());
                }
            }
            if (this.filterDefinitions != null) {
                for (int i = 0; i < this.filterDefinitions.length; ++i) {
                    config.addFilterDefinition(this.filterDefinitions[i]);
                }
            }
            if (this.configLocations != null) {
                for (int i = 0; i < this.configLocations.length; ++i) {
                    config.configure(this.configLocations[i].getURL());
                }
            }
            if (this.hibernateProperties != null) {
                config.addProperties(this.hibernateProperties);
            }
            if (this.dataSource != null) {
                boolean actuallyTransactionAware;
                boolean bl = actuallyTransactionAware = this.useTransactionAwareDataSource || this.dataSource instanceof TransactionAwareDataSourceProxy;
                config.setProperty("hibernate.connection.provider_class", actuallyTransactionAware ? (class$org$springframework$orm$hibernate3$TransactionAwareDataSourceConnectionProvider == null ? (class$org$springframework$orm$hibernate3$TransactionAwareDataSourceConnectionProvider = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate3.TransactionAwareDataSourceConnectionProvider")) : class$org$springframework$orm$hibernate3$TransactionAwareDataSourceConnectionProvider).getName() : (class$org$springframework$orm$hibernate3$LocalDataSourceConnectionProvider == null ? (class$org$springframework$orm$hibernate3$LocalDataSourceConnectionProvider = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate3.LocalDataSourceConnectionProvider")) : class$org$springframework$orm$hibernate3$LocalDataSourceConnectionProvider).getName());
            }
            if (this.mappingLocations != null) {
                for (int i = 0; i < this.mappingLocations.length; ++i) {
                    config.addInputStream(this.mappingLocations[i].getInputStream());
                }
            }
            if (this.cacheableMappingLocations != null) {
                for (int i = 0; i < this.cacheableMappingLocations.length; ++i) {
                    config.addCacheableFile(this.cacheableMappingLocations[i].getFile());
                }
            }
            if (this.mappingJarLocations != null) {
                for (int i = 0; i < this.mappingJarLocations.length; ++i) {
                    Resource resource = this.mappingJarLocations[i];
                    config.addJar(resource.getFile());
                }
            }
            if (this.mappingDirectoryLocations != null) {
                for (int i = 0; i < this.mappingDirectoryLocations.length; ++i) {
                    File file = this.mappingDirectoryLocations[i].getFile();
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("Mapping directory location [" + this.mappingDirectoryLocations[i] + "] does not denote a directory");
                    }
                    config.addDirectory(file);
                }
            }
            if (this.entityCacheStrategies != null) {
                Enumeration<?> classNames = this.entityCacheStrategies.propertyNames();
                while (classNames.hasMoreElements()) {
                    String className = (String)classNames.nextElement();
                    strategyAndRegion = StringUtils.commaDelimitedListToStringArray(this.entityCacheStrategies.getProperty(className));
                    if (strategyAndRegion.length > 1) {
                        config.setCacheConcurrencyStrategy(className, strategyAndRegion[0], strategyAndRegion[1]);
                        continue;
                    }
                    if (strategyAndRegion.length <= 0) continue;
                    config.setCacheConcurrencyStrategy(className, strategyAndRegion[0]);
                }
            }
            if (this.collectionCacheStrategies != null) {
                Enumeration<?> collRoles = this.collectionCacheStrategies.propertyNames();
                while (collRoles.hasMoreElements()) {
                    String collRole = (String)collRoles.nextElement();
                    strategyAndRegion = StringUtils.commaDelimitedListToStringArray(this.collectionCacheStrategies.getProperty(collRole));
                    if (strategyAndRegion.length > 1) {
                        config.setCollectionCacheConcurrencyStrategy(collRole, strategyAndRegion[0], strategyAndRegion[1]);
                        continue;
                    }
                    if (strategyAndRegion.length <= 0) continue;
                    config.setCollectionCacheConcurrencyStrategy(collRole, strategyAndRegion[0]);
                }
            }
            if (this.eventListeners != null) {
                Iterator it = this.eventListeners.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Assert.isTrue(entry.getKey() instanceof String, "Event listener key needs to be of type String");
                    String listenerType = (String)entry.getKey();
                    Object listenerObject = entry.getValue();
                    if (listenerObject instanceof Collection) {
                        Collection listeners = (Collection)listenerObject;
                        EventListeners listenerRegistry = config.getEventListeners();
                        Object[] listenerArray = (Object[])Array.newInstance(listenerRegistry.getListenerClassFor(listenerType), listeners.size());
                        listenerArray = listeners.toArray(listenerArray);
                        config.setListeners(listenerType, listenerArray);
                        continue;
                    }
                    config.setListener(listenerType, listenerObject);
                }
            }
            this.postProcessConfiguration(config);
            this.logger.info("Building new Hibernate SessionFactory");
            this.configuration = config;
            SessionFactory sessionFactory = this.newSessionFactory(config);
            return sessionFactory;
        }
        finally {
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(null);
            }
            if (this.jtaTransactionManager != null) {
                configTimeTransactionManagerHolder.set(null);
            }
            if (this.lobHandler != null) {
                configTimeLobHandlerHolder.set(null);
            }
        }
    }

    protected Configuration newConfiguration() throws HibernateException {
        return (Configuration)BeanUtils.instantiateClass(this.configurationClass);
    }

    protected void postProcessConfiguration(Configuration config) throws HibernateException {
    }

    protected SessionFactory newSessionFactory(Configuration config) throws HibernateException {
        return config.buildSessionFactory();
    }

    public final Configuration getConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException("Configuration not initialized yet");
        }
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterSessionFactoryCreation() throws Exception {
        if (this.schemaUpdate) {
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(this.dataSource);
            }
            try {
                this.updateDatabaseSchema();
            }
            finally {
                if (this.dataSource != null) {
                    configTimeDataSourceHolder.set(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws HibernateException {
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        try {
            super.destroy();
        }
        finally {
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(null);
            }
        }
    }

    public void dropDatabaseSchema() throws DataAccessException {
        this.logger.info("Dropping database schema for Hibernate SessionFactory");
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection con = session.connection();
                Dialect dialect = Dialect.getDialect(LocalSessionFactoryBean.this.getConfiguration().getProperties());
                String[] sql = LocalSessionFactoryBean.this.getConfiguration().generateDropSchemaScript(dialect);
                LocalSessionFactoryBean.this.executeSchemaScript(con, sql);
                return null;
            }
        });
    }

    public void createDatabaseSchema() throws DataAccessException {
        this.logger.info("Creating database schema for Hibernate SessionFactory");
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection con = session.connection();
                Dialect dialect = Dialect.getDialect(LocalSessionFactoryBean.this.getConfiguration().getProperties());
                String[] sql = LocalSessionFactoryBean.this.getConfiguration().generateSchemaCreationScript(dialect);
                LocalSessionFactoryBean.this.executeSchemaScript(con, sql);
                return null;
            }
        });
    }

    public void updateDatabaseSchema() throws DataAccessException {
        this.logger.info("Updating database schema for Hibernate SessionFactory");
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        hibernateTemplate.setFlushMode(0);
        hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection con = session.connection();
                Dialect dialect = Dialect.getDialect(LocalSessionFactoryBean.this.getConfiguration().getProperties());
                DatabaseMetadata metadata = new DatabaseMetadata(con, dialect);
                String[] sql = LocalSessionFactoryBean.this.getConfiguration().generateSchemaUpdateScript(dialect, metadata);
                LocalSessionFactoryBean.this.executeSchemaScript(con, sql);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSchemaScript(Connection con, String[] sql) throws SQLException {
        if (sql != null && sql.length > 0) {
            boolean oldAutoCommit = con.getAutoCommit();
            if (!oldAutoCommit) {
                con.setAutoCommit(true);
            }
            try {
                Statement stmt = con.createStatement();
                try {
                    for (int i = 0; i < sql.length; ++i) {
                        this.executeSchemaStatement(stmt, sql[i]);
                    }
                }
                finally {
                    JdbcUtils.closeStatement(stmt);
                }
            }
            finally {
                if (!oldAutoCommit) {
                    con.setAutoCommit(false);
                }
            }
        }
    }

    protected void executeSchemaStatement(Statement stmt, String sql) throws SQLException {
        block3: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing schema statement: " + sql);
            }
            try {
                stmt.executeUpdate(sql);
            }
            catch (SQLException ex) {
                if (!this.logger.isWarnEnabled()) break block3;
                this.logger.warn("Unsuccessful schema statement: " + sql, ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

