/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.orm.ibatis.SqlMapClientCallback;
import org.springframework.orm.ibatis.SqlMapClientOperations;
import org.springframework.util.Assert;

public class SqlMapClientTemplate
extends JdbcAccessor
implements SqlMapClientOperations {
    private SqlMapClient sqlMapClient;
    private boolean lazyLoadingAvailable = true;

    public SqlMapClientTemplate() {
    }

    public SqlMapClientTemplate(SqlMapClient sqlMapClient) {
        this.setSqlMapClient(sqlMapClient);
        this.afterPropertiesSet();
    }

    public SqlMapClientTemplate(DataSource dataSource, SqlMapClient sqlMapClient) {
        this.setDataSource(dataSource);
        this.setSqlMapClient(sqlMapClient);
        this.afterPropertiesSet();
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public DataSource getDataSource() {
        DataSource ds = super.getDataSource();
        return ds != null ? ds : this.sqlMapClient.getDataSource();
    }

    public void afterPropertiesSet() {
        if (this.sqlMapClient == null) {
            throw new IllegalArgumentException("sqlMapClient is required");
        }
        if (this.sqlMapClient instanceof ExtendedSqlMapClient) {
            this.lazyLoadingAvailable = ((ExtendedSqlMapClient)this.sqlMapClient).getDelegate().getTxManager() != null;
        }
        super.afterPropertiesSet();
    }

    public Object execute(SqlMapClientCallback action) throws DataAccessException {
        Assert.notNull(action, "Callback object must not be null");
        Assert.notNull(this.sqlMapClient, "No SqlMapClient specified");
        SqlMapSession session = this.sqlMapClient.openSession();
        Connection ibatisCon = null;
        try {
            Object object;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Opened SqlMapSession [" + session + "] for iBATIS operation");
            }
            Connection springCon = null;
            try {
                ibatisCon = session.getCurrentConnection();
                if (ibatisCon == null) {
                    springCon = DataSourceUtils.getConnection(this.getDataSource());
                    session.setUserConnection(springCon);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Obtained JDBC Connection [" + springCon + "] for iBATIS operation");
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Reusing JDBC Connection [" + ibatisCon + "] for iBATIS operation");
                }
                object = action.doInSqlMapClient((SqlMapExecutor)session);
            }
            catch (SQLException ex) {
                try {
                    throw this.getExceptionTranslator().translate("SqlMapClient operation", null, ex);
                }
                catch (Throwable throwable) {
                    DataSourceUtils.releaseConnection(springCon, this.getDataSource());
                    throw throwable;
                }
            }
            DataSourceUtils.releaseConnection(springCon, this.getDataSource());
            return object;
        }
        finally {
            if (ibatisCon == null) {
                session.close();
            }
        }
    }

    public List executeWithListResult(SqlMapClientCallback action) throws DataAccessException {
        return (List)this.execute(action);
    }

    public Map executeWithMapResult(SqlMapClientCallback action) throws DataAccessException {
        return (Map)this.execute(action);
    }

    public Object queryForObject(String statementName) throws DataAccessException {
        return this.queryForObject(statementName, null);
    }

    public Object queryForObject(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(statementName, parameterObject);
            }
        });
    }

    public Object queryForObject(final String statementName, final Object parameterObject, final Object resultObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(statementName, parameterObject, resultObject);
            }
        });
    }

    public List queryForList(String statementName) throws DataAccessException {
        return this.queryForList(statementName, null);
    }

    public List queryForList(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.executeWithListResult(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(statementName, parameterObject);
            }
        });
    }

    public List queryForList(String statementName, int skipResults, int maxResults) throws DataAccessException {
        return this.queryForList(statementName, null, skipResults, maxResults);
    }

    public List queryForList(final String statementName, final Object parameterObject, final int skipResults, final int maxResults) throws DataAccessException {
        return this.executeWithListResult(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(statementName, parameterObject, skipResults, maxResults);
            }
        });
    }

    public void queryWithRowHandler(String statementName, RowHandler rowHandler) throws DataAccessException {
        this.queryWithRowHandler(statementName, null, rowHandler);
    }

    public void queryWithRowHandler(final String statementName, final Object parameterObject, final RowHandler rowHandler) throws DataAccessException {
        this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                executor.queryWithRowHandler(statementName, parameterObject, rowHandler);
                return null;
            }
        });
    }

    public PaginatedList queryForPaginatedList(String statementName, int pageSize) throws DataAccessException {
        return this.queryForPaginatedList(statementName, null, pageSize);
    }

    public PaginatedList queryForPaginatedList(final String statementName, final Object parameterObject, final int pageSize) throws DataAccessException {
        if (!this.lazyLoadingAvailable) {
            throw new InvalidDataAccessApiUsageException("SqlMapClient needs to have DataSource to allow for lazy loading - specify SqlMapClientFactoryBean's 'dataSource' property");
        }
        return (PaginatedList)this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForPaginatedList(statementName, parameterObject, pageSize);
            }
        });
    }

    public Map queryForMap(final String statementName, final Object parameterObject, final String keyProperty) throws DataAccessException {
        return this.executeWithMapResult(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(statementName, parameterObject, keyProperty);
            }
        });
    }

    public Map queryForMap(final String statementName, final Object parameterObject, final String keyProperty, final String valueProperty) throws DataAccessException {
        return this.executeWithMapResult(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(statementName, parameterObject, keyProperty, valueProperty);
            }
        });
    }

    public Object insert(String statementName) throws DataAccessException {
        return this.insert(statementName, null);
    }

    public Object insert(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.insert(statementName, parameterObject);
            }
        });
    }

    public int update(String statementName) throws DataAccessException {
        return this.update(statementName, null);
    }

    public int update(final String statementName, final Object parameterObject) throws DataAccessException {
        Integer result = (Integer)this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return new Integer(executor.update(statementName, parameterObject));
            }
        });
        return result;
    }

    public void update(String statementName, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        int actualRowsAffected = this.update(statementName, parameterObject);
        if (actualRowsAffected != requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(statementName, requiredRowsAffected, actualRowsAffected);
        }
    }

    public int delete(String statementName) throws DataAccessException {
        return this.delete(statementName, null);
    }

    public int delete(final String statementName, final Object parameterObject) throws DataAccessException {
        Integer result = (Integer)this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return new Integer(executor.delete(statementName, parameterObject));
            }
        });
        return result;
    }

    public void delete(String statementName, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        int actualRowsAffected = this.delete(statementName, parameterObject);
        if (actualRowsAffected != requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(statementName, requiredRowsAffected, actualRowsAffected);
        }
    }
}

