/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.support;

import junit.framework.TestCase;
import org.springframework.core.JdkVersion;
import org.springframework.remoting.support.RemoteInvocationUtils;

public final class RemoteInvocationUtilsTests
extends TestCase {
    public void testFillInClientStackTraceIfPossibleSunnyDay() throws Exception {
        if (!JdkVersion.isAtLeastJava14()) {
            return;
        }
        try {
            throw new IllegalStateException("Mmm");
        }
        catch (Exception ex) {
            int originalStackTraceLngth = ex.getStackTrace().length;
            RemoteInvocationUtils.fillInClientStackTraceIfPossible(ex);
            RemoteInvocationUtilsTests.assertTrue("Stack trace not being filled in", ex.getStackTrace().length > originalStackTraceLngth);
            return;
        }
    }

    public void testFillInClientStackTraceIfPossibleWithNullThrowable() throws Exception {
        if (!JdkVersion.isAtLeastJava14()) {
            return;
        }
        RemoteInvocationUtils.fillInClientStackTraceIfPossible(null);
    }
}

