/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.support;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class ResourceScriptSource
implements ScriptSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Resource resource;
    private long lastModified = -1L;

    public ResourceScriptSource(Resource resource) {
        Assert.notNull(resource, "Resource must not be null");
        this.resource = resource;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public String getScriptAsString() throws IOException {
        this.lastModified = this.retrieveLastModifiedTime();
        InputStreamReader reader = null;
        try {
            reader = new FileReader(this.resource.getFile());
        }
        catch (IOException ex) {
            reader = new InputStreamReader(this.resource.getInputStream());
        }
        return FileCopyUtils.copyToString(reader);
    }

    public boolean isModified() {
        if (this.lastModified < 0L) {
            return true;
        }
        return this.retrieveLastModifiedTime() > this.lastModified;
    }

    protected long retrieveLastModifiedTime() {
        try {
            File file = this.getResource().getFile();
            return file.lastModified();
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getResource() + " could not be resolved in the file system - current timestamp not available", ex);
            }
            return 0L;
        }
    }

    public String toString() {
        return this.resource.toString();
    }
}

