/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ObjectUtils;

public abstract class AbstractFallbackTransactionAttributeSource
implements TransactionAttributeSource {
    private static final Object NULL_TRANSACTION_ATTRIBUTE = new Object();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map cache = new HashMap();

    public final TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        Object cacheKey = this.getCacheKey(method, targetClass);
        Object cached = this.cache.get(cacheKey);
        if (cached != null) {
            if (cached == NULL_TRANSACTION_ATTRIBUTE) {
                return null;
            }
            return (TransactionAttribute)cached;
        }
        TransactionAttribute txAtt = this.computeTransactionAttribute(method, targetClass);
        if (txAtt == null) {
            this.cache.put(cacheKey, NULL_TRANSACTION_ATTRIBUTE);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding transactional method [" + method.getName() + "] with attribute [" + txAtt + "]");
            }
            this.cache.put(cacheKey, txAtt);
        }
        return txAtt;
    }

    protected Object getCacheKey(Method method, Class targetClass) {
        return new DefaultCacheKey(method, targetClass);
    }

    private TransactionAttribute computeTransactionAttribute(Method method, Class targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = AopUtils.getMostSpecificMethod(method, targetClass);
        TransactionAttribute txAtt = this.findTransactionAttribute(this.findAllAttributes(specificMethod));
        if (txAtt != null) {
            return txAtt;
        }
        txAtt = this.findTransactionAttribute(this.findAllAttributes(specificMethod.getDeclaringClass()));
        if (txAtt != null) {
            return txAtt;
        }
        if (specificMethod != method) {
            txAtt = this.findTransactionAttribute(this.findAllAttributes(method));
            if (txAtt != null) {
                return txAtt;
            }
            return this.findTransactionAttribute(this.findAllAttributes(method.getDeclaringClass()));
        }
        return null;
    }

    protected abstract Collection findAllAttributes(Method var1);

    protected abstract Collection findAllAttributes(Class var1);

    protected TransactionAttribute findTransactionAttribute(Collection atts) {
        if (atts == null) {
            return null;
        }
        TransactionAttribute txAttribute = null;
        Iterator itr = atts.iterator();
        while (itr.hasNext() && txAttribute == null) {
            Object att = itr.next();
            if (!(att instanceof TransactionAttribute)) continue;
            txAttribute = (TransactionAttribute)att;
        }
        if (txAttribute instanceof RuleBasedTransactionAttribute) {
            RuleBasedTransactionAttribute rbta = (RuleBasedTransactionAttribute)txAttribute;
            LinkedList rollbackRules = new LinkedList();
            Iterator it = atts.iterator();
            while (it.hasNext()) {
                Object att = it.next();
                if (!(att instanceof RollbackRuleAttribute)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found rollback rule: " + att);
                }
                rollbackRules.add(att);
            }
            rbta.setRollbackRules(rollbackRules);
        }
        return txAttribute;
    }

    protected boolean allowPublicMethodsOnly() {
        return false;
    }

    private static class DefaultCacheKey {
        private final Method method;
        private final Class targetClass;

        public DefaultCacheKey(Method method, Class targetClass) {
            this.method = method;
            this.targetClass = targetClass;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultCacheKey)) {
                return false;
            }
            DefaultCacheKey otherKey = (DefaultCacheKey)other;
            return this.method.equals(otherKey.method) && ObjectUtils.nullSafeEquals(this.targetClass, otherKey.targetClass);
        }

        public int hashCode() {
            return this.method.hashCode() * 29 + (this.targetClass != null ? this.targetClass.hashCode() : 0);
        }
    }
}

