/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class ControllerClassNameHandlerMapping
extends AbstractUrlHandlerMapping
implements HandlerMapping {
    private static final String CONTROLLER_SUFFIX = "Controller";
    protected final Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$Controller;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$multiaction$MultiActionController;

    protected void initApplicationContext() {
        super.initApplicationContext();
        this.detectControllers();
    }

    protected void detectControllers() throws BeansException {
        this.registerControllers(class$org$springframework$web$servlet$mvc$Controller == null ? (class$org$springframework$web$servlet$mvc$Controller = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.Controller")) : class$org$springframework$web$servlet$mvc$Controller);
        this.registerControllers(class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController == null ? (class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.throwaway.ThrowawayController")) : class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController);
    }

    protected void registerControllers(Class controllerType) throws BeansException {
        String[] beanNames = this.getApplicationContext().getBeanNamesForType(controllerType);
        for (int i = 0; i < beanNames.length; ++i) {
            this.registerController(beanNames[i]);
        }
    }

    protected void registerController(String beanName) throws BeansException, IllegalStateException {
        Class controllerClass = this.getApplicationContext().getType(beanName);
        String urlPath = this.generatePathMapping(controllerClass);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering Controller '" + beanName + "' as handler for URL path [" + urlPath + "]");
        }
        this.registerHandler(urlPath, (Object)beanName);
    }

    protected String generatePathMapping(Class controllerClass) {
        StringBuffer pathMapping = new StringBuffer("/");
        String className = ClassUtils.getShortName(controllerClass.getName());
        String path = className.endsWith(CONTROLLER_SUFFIX) ? className.substring(0, className.indexOf(CONTROLLER_SUFFIX)) : className;
        pathMapping.append(path.toLowerCase());
        if ((class$org$springframework$web$servlet$mvc$multiaction$MultiActionController == null ? (class$org$springframework$web$servlet$mvc$multiaction$MultiActionController = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.multiaction.MultiActionController")) : class$org$springframework$web$servlet$mvc$multiaction$MultiActionController).isAssignableFrom(controllerClass)) {
            pathMapping.append("/*");
        } else {
            pathMapping.append("*");
        }
        return pathMapping.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

