/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementBodyTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.util.TagUtils;

public class OptionTag
extends AbstractHtmlElementBodyTag
implements BodyTag {
    public static final String VALUE_VARIABLE_NAME = "value";
    public static final String DISPLAY_VALUE_VARIABLE_NAME = "displayValue";
    private static final String SELECTED_ATTRIBUTE = "selected";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String DISABLED_ATTRIBUTE = "disabled";
    private Object value;
    private String label;
    private Object oldValue;
    private Object oldDisplayValue;
    private String disabled;
    static /* synthetic */ Class class$org$springframework$web$servlet$tags$form$SelectTag;

    public void setValue(Object value) {
        this.value = value;
    }

    protected Object getValue() {
        return this.value;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    protected String getDisabled() {
        return this.disabled;
    }

    protected boolean isDisabled() {
        return "true".equals(this.getDisabled());
    }

    public void setLabel(String label) {
        Assert.notNull(label, "'label' cannot be null.");
        this.label = label;
    }

    protected String getLabel() {
        return this.label;
    }

    protected void renderDefaultContent(TagWriter tagWriter) throws JspException {
        Object value = this.pageContext.getAttribute("value");
        String label = this.getLabelValue(value);
        this.renderOption(value, label, tagWriter);
    }

    protected void renderFromBodyContent(BodyContent bodyContent, TagWriter tagWriter) throws JspException {
        Object value = this.pageContext.getAttribute("value");
        String label = bodyContent.getString();
        this.renderOption(value, label, tagWriter);
    }

    protected void onWriteTagContent() {
        this.assertUnderSelectTag();
    }

    protected void exposeAttributes() throws JspException {
        Object value = this.resolveValue();
        this.oldValue = this.pageContext.getAttribute("value");
        this.pageContext.setAttribute("value", value);
        this.oldDisplayValue = this.pageContext.getAttribute(DISPLAY_VALUE_VARIABLE_NAME);
        this.pageContext.setAttribute(DISPLAY_VALUE_VARIABLE_NAME, this.getDisplayString(value, this.getBindStatus().getEditor()));
    }

    protected BindStatus getBindStatus() {
        return (BindStatus)this.pageContext.getAttribute("org.springframework.web.servlet.tags.form.SelectTag.listValue");
    }

    protected void removeAttributes() {
        if (this.oldValue != null) {
            this.pageContext.setAttribute("value", this.oldValue);
            this.oldValue = null;
        } else {
            this.pageContext.removeAttribute("value");
        }
        if (this.oldDisplayValue != null) {
            this.pageContext.setAttribute(DISPLAY_VALUE_VARIABLE_NAME, this.oldDisplayValue);
            this.oldDisplayValue = null;
        } else {
            this.pageContext.removeAttribute(DISPLAY_VALUE_VARIABLE_NAME);
        }
    }

    private void renderOption(Object value, String label, TagWriter tagWriter) throws JspException {
        tagWriter.startTag("option");
        String renderedValue = this.getDisplayString(value, this.getBindStatus().getEditor());
        tagWriter.writeAttribute("value", renderedValue);
        if (this.isSelected(value)) {
            tagWriter.writeAttribute(SELECTED_ATTRIBUTE, SELECTED_ATTRIBUTE);
        }
        if (this.isDisabled()) {
            tagWriter.writeAttribute(DISABLED_ATTRIBUTE, DISABLED_ATTRIBUTE);
        }
        tagWriter.appendValue(label);
        tagWriter.endTag();
    }

    private String getLabelValue(Object resolvedValue) throws JspException {
        String label = this.getLabel();
        Object labelObj = label == null ? resolvedValue : this.evaluate("label", label);
        return this.getDisplayString(labelObj, this.getBindStatus().getEditor());
    }

    private void assertUnderSelectTag() {
        TagUtils.assertHasAncestorOfType(this, class$org$springframework$web$servlet$tags$form$SelectTag == null ? (class$org$springframework$web$servlet$tags$form$SelectTag = OptionTag.class$("org.springframework.web.servlet.tags.form.SelectTag")) : class$org$springframework$web$servlet$tags$form$SelectTag, "option", "select");
    }

    private boolean isSelected(Object resolvedValue) {
        return SelectedValueComparator.isSelected(this.getBindStatus(), resolvedValue);
    }

    private Object resolveValue() throws JspException {
        return this.evaluate("value", this.getValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

