/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TagWriter {
    private final SafeWriter writer;
    private Stack tagState = new Stack();

    public TagWriter(Writer writer) {
        Assert.notNull(writer);
        this.writer = new SafeWriter(writer);
    }

    public void startTag(String tagName) throws JspException {
        if (this.inTag()) {
            this.closeTagAndMarkAsBlock();
        }
        this.push(tagName);
        this.writer.append("<").append(tagName);
    }

    public void writeAttribute(String attributeName, String attributeValue) throws JspException {
        if (this.currentState().isBlockTag()) {
            throw new IllegalStateException("Cannot write attributes after opening tag is closed.");
        }
        this.writer.append(" ").append(attributeName).append("=\"").append(attributeValue).append("\"");
    }

    public void writeOptionalAttributeValue(String attributeName, String attributeValue) throws JspException {
        if (StringUtils.hasText(attributeValue)) {
            this.writeAttribute(attributeName, attributeValue);
        }
    }

    public void appendValue(String value) throws JspException {
        if (!this.inTag()) {
            throw new IllegalStateException("Cannot write tag value. No open tag available.");
        }
        this.closeTagAndMarkAsBlock();
        this.writer.append(value);
    }

    public void forceBlock() throws JspException {
        if (this.currentState().isBlockTag()) {
            return;
        }
        this.closeTagAndMarkAsBlock();
    }

    public void endTag() throws JspException {
        if (!this.inTag()) {
            throw new IllegalStateException("Cannot write end of tag. No open tag available.");
        }
        if (this.currentState().isBlockTag()) {
            this.writer.append("</").append(this.currentState().getTagName()).append(">");
        } else {
            this.writer.append("/>");
        }
        this.tagState.pop();
    }

    private void push(String tagName) {
        this.tagState.push(new TagStateEntry(tagName));
    }

    private void closeTagAndMarkAsBlock() throws JspException {
        if (!this.currentState().isBlockTag()) {
            this.currentState().markAsBlockTag();
            this.writer.append(">");
        }
    }

    private boolean inTag() {
        return this.tagState.size() > 0;
    }

    private TagStateEntry currentState() {
        return (TagStateEntry)this.tagState.peek();
    }

    private static final class SafeWriter {
        private final Writer writer;

        public SafeWriter(Writer writer) {
            this.writer = writer;
        }

        public SafeWriter append(String value) throws JspException {
            try {
                this.writer.write(String.valueOf(value));
                return this;
            }
            catch (IOException ex) {
                throw new JspException("Unable to write to JspWriter", ex);
            }
        }
    }

    private static final class TagStateEntry {
        private final String tagName;
        private boolean blockTag;

        public TagStateEntry(String tagName) {
            this.tagName = tagName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public boolean isBlockTag() {
            return this.blockTag;
        }

        public void markAsBlockTag() {
            this.blockTag = true;
        }
    }
}

