/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class ExpressionEvaluationUtils {
    public static final String EXPRESSION_CACHE_CONTEXT_PARAM = "cacheJspExpressions";
    public static final String EXPRESSION_PREFIX = "${";
    public static final String EXPRESSION_SUFFIX = "}";
    private static final String EXPRESSION_CACHE_FLAG_CONTEXT_ATTR = (class$org$springframework$web$util$ExpressionEvaluationUtils == null ? (class$org$springframework$web$util$ExpressionEvaluationUtils = ExpressionEvaluationUtils.class$("org.springframework.web.util.ExpressionEvaluationUtils")) : class$org$springframework$web$util$ExpressionEvaluationUtils).getName() + ".CACHE_JSP_EXPRESSIONS";
    private static final String EXPRESSION_CACHE_MAP_CONTEXT_ATTR = (class$org$springframework$web$util$ExpressionEvaluationUtils == null ? (class$org$springframework$web$util$ExpressionEvaluationUtils = ExpressionEvaluationUtils.class$("org.springframework.web.util.ExpressionEvaluationUtils")) : class$org$springframework$web$util$ExpressionEvaluationUtils).getName() + ".JSP_EXPRESSION_CACHE";
    private static final String JSP_20_CLASS_NAME = "javax.servlet.jsp.el.ExpressionEvaluator";
    private static final String JAKARTA_JSTL_CLASS_NAME = "org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager";
    private static final Log logger = LogFactory.getLog(class$org$springframework$web$util$ExpressionEvaluationUtils == null ? (class$org$springframework$web$util$ExpressionEvaluationUtils = ExpressionEvaluationUtils.class$("org.springframework.web.util.ExpressionEvaluationUtils")) : class$org$springframework$web$util$ExpressionEvaluationUtils);
    private static ExpressionEvaluationHelper helper;
    static /* synthetic */ Class class$org$springframework$web$util$ExpressionEvaluationUtils;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static boolean isExpressionLanguage(String value) {
        return value != null && value.indexOf(EXPRESSION_PREFIX) != -1;
    }

    public static Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, resultClass, pageContext);
        }
        if (attrValue != null && resultClass != null && !resultClass.isInstance(attrValue)) {
            throw new JspException("Attribute value \"" + attrValue + "\" is neither a JSP EL expression nor " + "assignable to result class [" + resultClass.getName() + "]");
        }
        return attrValue;
    }

    public static Object evaluate(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, class$java$lang$Object == null ? (class$java$lang$Object = ExpressionEvaluationUtils.class$("java.lang.Object")) : class$java$lang$Object, pageContext);
        }
        return attrValue;
    }

    public static String evaluateString(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (String)ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, class$java$lang$String == null ? (class$java$lang$String = ExpressionEvaluationUtils.class$("java.lang.String")) : class$java$lang$String, pageContext);
        }
        return attrValue;
    }

    public static int evaluateInteger(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (Integer)ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, class$java$lang$Integer == null ? (class$java$lang$Integer = ExpressionEvaluationUtils.class$("java.lang.Integer")) : class$java$lang$Integer, pageContext);
        }
        return Integer.parseInt(attrValue);
    }

    public static boolean evaluateBoolean(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (Boolean)ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ExpressionEvaluationUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, pageContext);
        }
        return Boolean.valueOf(attrValue);
    }

    private static Object doEvaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
        Assert.notNull(attrValue, "Attribute value must not be null");
        Assert.notNull(resultClass, "Result class must not be null");
        Assert.notNull(pageContext, "PageContext must not be null");
        if (resultClass.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = ExpressionEvaluationUtils.class$("java.lang.String")) : class$java$lang$String)) {
            StringBuffer resultValue = null;
            int exprPrefixIndex = -1;
            int exprSuffixIndex = 0;
            do {
                if ((exprPrefixIndex = attrValue.indexOf(EXPRESSION_PREFIX, exprSuffixIndex)) != -1) {
                    int prevExprSuffixIndex = exprSuffixIndex;
                    exprSuffixIndex = attrValue.indexOf(EXPRESSION_SUFFIX, exprPrefixIndex + EXPRESSION_PREFIX.length());
                    String expr = null;
                    expr = exprSuffixIndex != -1 ? attrValue.substring(exprPrefixIndex, exprSuffixIndex += EXPRESSION_SUFFIX.length()) : attrValue.substring(exprPrefixIndex);
                    if (expr.length() == attrValue.length()) {
                        return helper.evaluate(attrName, attrValue, resultClass, pageContext);
                    }
                    if (resultValue == null) {
                        resultValue = new StringBuffer();
                    }
                    resultValue.append(attrValue.substring(prevExprSuffixIndex, exprPrefixIndex));
                    resultValue.append(helper.evaluate(attrName, expr, class$java$lang$String == null ? ExpressionEvaluationUtils.class$("java.lang.String") : class$java$lang$String, pageContext));
                    continue;
                }
                if (resultValue == null) {
                    resultValue = new StringBuffer();
                }
                resultValue.append(attrValue.substring(exprSuffixIndex));
            } while (exprPrefixIndex != -1 && exprSuffixIndex != -1);
            return resultValue.toString();
        }
        return helper.evaluate(attrName, attrValue, resultClass, pageContext);
    }

    private static Map getJspExpressionCache(PageContext pageContext) {
        ServletContext servletContext = pageContext.getServletContext();
        Map cacheMap = (Map)servletContext.getAttribute(EXPRESSION_CACHE_MAP_CONTEXT_ATTR);
        if (cacheMap == null) {
            Boolean cacheFlag = (Boolean)servletContext.getAttribute(EXPRESSION_CACHE_FLAG_CONTEXT_ATTR);
            if (cacheFlag == null) {
                cacheFlag = Boolean.valueOf(servletContext.getInitParameter(EXPRESSION_CACHE_CONTEXT_PARAM));
                servletContext.setAttribute(EXPRESSION_CACHE_FLAG_CONTEXT_ATTR, cacheFlag);
            }
            if (cacheFlag.booleanValue()) {
                cacheMap = Collections.synchronizedMap(new HashMap());
                servletContext.setAttribute(EXPRESSION_CACHE_MAP_CONTEXT_ATTR, cacheMap);
            }
        }
        return cacheMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (ClassUtils.isPresent(JSP_20_CLASS_NAME)) {
            logger.info("Found JSP 2.0 ExpressionEvaluator");
            if (ClassUtils.isPresent(JAKARTA_JSTL_CLASS_NAME)) {
                logger.info("Found Jakarta JSTL ExpressionEvaluatorManager");
                helper = new Jsp20ExpressionEvaluationHelper(new JakartaExpressionEvaluationHelper());
            } else {
                helper = new Jsp20ExpressionEvaluationHelper(new NoExpressionEvaluationHelper());
            }
        } else if (ClassUtils.isPresent(JAKARTA_JSTL_CLASS_NAME)) {
            logger.info("Found Jakarta JSTL ExpressionEvaluatorManager");
            helper = new JakartaExpressionEvaluationHelper();
        } else {
            logger.info("JSP expression evaluation not available");
            helper = new NoExpressionEvaluationHelper();
        }
    }

    private static class ExpressionCacheKey {
        private final String value;
        private final Class resultClass;
        private final int hashCode;

        public ExpressionCacheKey(String value, Class resultClass) {
            this.value = value;
            this.resultClass = resultClass;
            this.hashCode = this.value.hashCode() * 29 + this.resultClass.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExpressionCacheKey)) {
                return false;
            }
            ExpressionCacheKey other = (ExpressionCacheKey)obj;
            return this.value.equals(other.value) && this.resultClass.equals(other.resultClass);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class Jsp20ExpressionEvaluationHelper
    implements ExpressionEvaluationHelper {
        private final ExpressionEvaluationHelper fallback;
        private boolean fallbackNecessary = false;

        public Jsp20ExpressionEvaluationHelper(ExpressionEvaluationHelper fallback) {
            this.fallback = fallback;
        }

        public Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
            if (this.isFallbackNecessary()) {
                return this.fallback.evaluate(attrName, attrValue, resultClass, pageContext);
            }
            try {
                Map expressionCache = ExpressionEvaluationUtils.getJspExpressionCache(pageContext);
                if (expressionCache != null) {
                    ExpressionCacheKey cacheKey = new ExpressionCacheKey(attrValue, resultClass);
                    Expression expr = (Expression)expressionCache.get(cacheKey);
                    if (expr == null) {
                        expr = pageContext.getExpressionEvaluator().parseExpression(attrValue, resultClass, null);
                        expressionCache.put(cacheKey, expr);
                    }
                    return expr.evaluate(pageContext.getVariableResolver());
                }
                return pageContext.getExpressionEvaluator().evaluate(attrValue, resultClass, pageContext.getVariableResolver(), null);
            }
            catch (ELException ex) {
                throw new JspException("Parsing of JSP EL expression \"" + attrValue + "\" failed", ex);
            }
            catch (LinkageError err) {
                logger.debug("JSP 2.0 ExpressionEvaluator API present but not implemented - using fallback", err);
                this.setFallbackNecessary();
                return this.fallback.evaluate(attrName, attrValue, resultClass, pageContext);
            }
        }

        private synchronized boolean isFallbackNecessary() {
            return this.fallbackNecessary;
        }

        private synchronized void setFallbackNecessary() {
            this.fallbackNecessary = true;
        }
    }

    private static class JakartaExpressionEvaluationHelper
    implements ExpressionEvaluationHelper {
        private JakartaExpressionEvaluationHelper() {
        }

        public Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
            return ExpressionEvaluatorManager.evaluate((String)attrName, (String)attrValue, (Class)resultClass, (PageContext)pageContext);
        }
    }

    private static class NoExpressionEvaluationHelper
    implements ExpressionEvaluationHelper {
        private NoExpressionEvaluationHelper() {
        }

        public Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
            throw new JspException("Neither JSP 2.0 nor Jakarta JSTL available - cannot parse JSP EL expression \"" + attrValue + "\"");
        }
    }

    private static interface ExpressionEvaluationHelper {
        public Object evaluate(String var1, String var2, Class var3, PageContext var4) throws JspException;
    }
}

