/* gsl_nan.h

 * 

 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough

 * 

 * This program is free software; you can redistribute it and/or modify

 * it under the terms of the GNU General Public License as published by

 * the Free Software Foundation; either version 2 of the License, or (at

 * your option) any later version.

 * 

 * This program is distributed in the hope that it will be useful, but

 * WITHOUT ANY WARRANTY; without even the implied warranty of

 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU

 * General Public License for more details.

 * 

 * You should have received a copy of the GNU General Public License

 * along with this program; if not, write to the Free Software

 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */



#ifndef __GSL_NAN_H__

#define __GSL_NAN_H__



#ifdef INFINITY

# define GSL_POSINF INFINITY

# define GSL_NEGINF (-INFINITY)

#elif defined(HUGE_VAL)

# define GSL_POSINF HUGE_VAL

# define GSL_NEGINF (-HUGE_VAL)

#else

# define GSL_POSINF (gsl_posinf())

# define GSL_NEGINF (gsl_neginf())

#endif



#ifdef NAN

# define GSL_NAN NAN

#elif defined(INFINITY)

# define GSL_NAN (INFINITY/INFINITY)

#else

# define GSL_NAN (gsl_nan())

#endif



#define GSL_POSZERO (+0)

#define GSL_NEGZERO (-0)



#endif /* __GSL_NAN_H__ */

