/*=========================================================================
 
 Program:   Open IGT Link -- Example for Data Receiving Client Program
 Module:    $RCSfile: $
 Language:  C++
 Date:      $Date: $
 Version:   $Revision: $
 
 Copyright (c) Insight Software Consortium. All rights reserved.
 
 This software is distributed WITHOUT ANY WARRANTY; without even
 the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the above copyright notices for more information.
 
 =========================================================================*/

#include <iostream>


//Sound input files

#include <lo/lo.h>
#include <sys/time.h>
// Sound related stuff
const char testdata[6] = "ABCDE";

int main(int argc, char* argv[])
{
  //------------------------------------------------------------
  // Sound related stuff - initialization
  //------------------------------------------------------------
  
  /* build a blob object from some data */
  lo_blob btest = lo_blob_new(sizeof(testdata), testdata);
  
  /* an address to send messages to. sometimes it is better to let the server
   * pick a port number for you by passing NULL as the last argument */
  //    lo_address t = lo_address_new_from_url( "osc.unix://localhost/tmp/mysocket" );
  //lo_address t = lo_address_new("172.16.203.210", "7400");
  lo_address t = lo_address_new("localhost", "7400");
  time_t currentTime;
  struct timespec req;
  
  timeval time;
  gettimeofday(&time, NULL);
  long millis = (time.tv_sec * 1000) + (time.tv_usec / 1000);
  while(1)
  {
    gettimeofday(&time, NULL);
    long currentMillis = (time.tv_sec * 1000) + (time.tv_usec / 1000) - millis;
    req.tv_sec  = 0;
    req.tv_nsec = 1e8;
    lo_send(t, "/dumpOSC/Distance", "i", int(currentMillis));
    while ((nanosleep(&req, &req) == -1) && (errno == EINTR))
    {
      continue;
    }
  }
}
