/*
 * Decompiled with CFR 0.152.
 */
package dart;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;

public class DartClient {
    static Logger logger = Logger.getLogger(class$dart$DartClient == null ? (class$dart$DartClient = DartClient.class$("dart.DartClient")) : class$dart$DartClient);
    static /* synthetic */ Class class$dart$DartClient;

    public static void main(String[] args) {
        XmlRpcClient admin;
        BasicConfigurator.configure();
        logger.info("Starting DartClient");
        PosixParser parser = new PosixParser();
        Options options = new Options();
        CommandLine cmd = null;
        int port = 8080;
        boolean printHelp = false;
        options.addOption("p", "port", true, "XML-RPC Port to connect to, 8081 is default");
        options.addOption("s", "server", true, "Server to connect to, localhost is default");
        options.addOption("h", "help", false, "Print help message");
        options.addOption("q", "shutdown", false, "Shutdown the Server");
        options.addOption("r", "refresh", false, "Refresh Project resources");
        options.addOption("R", "refreshServer", false, "Refresh Server resources");
        options.addOption("g", "getstatus", false, "Get Server status");
        try {
            cmd = parser.parse(options, args);
        }
        catch (Exception e) {
            logger.error("Failed to parse commandline", e);
            printHelp = true;
        }
        String[] files = cmd.getArgs();
        if (cmd.hasOption("h") || printHelp || files.length < 1) {
            new HelpFormatter().printHelp("DartClient [options] Project <foo1.xml> <foo2.xml> ... <fooN.xml>", options);
            System.exit(0);
        }
        try {
            port = Integer.parseInt(cmd.getOptionValue("p", "8081"));
        }
        catch (Exception e) {
            logger.error(cmd.getOptionValue("p", "8081") + " is not a valid port number");
            System.exit(1);
        }
        String project = files[0];
        XmlRpcClient client = null;
        try {
            client = new XmlRpcClient(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/" + project + "/Command/"));
        }
        catch (Exception e) {
            logger.error("Failed to create XmlRpcClient", e);
            System.exit(1);
        }
        if (cmd.hasOption("q")) {
            try {
                admin = new XmlRpcClient(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/DartServer/Command/"));
                Vector<String> aa = new Vector<String>();
                aa.addElement("Foo");
                aa.addElement("bar");
                admin.execute("Administration.shutdown", aa);
            }
            catch (Exception e) {
                logger.error("Failed to shutdown project", e);
                System.exit(1);
            }
        }
        if (cmd.hasOption("r")) {
            try {
                client.execute("Submit.refresh", new Vector());
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Failed to refresh project", e);
                System.exit(1);
            }
        }
        if (cmd.hasOption("R")) {
            try {
                admin = new XmlRpcClient(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/DartServer/Command/"));
                admin.execute("Administration.refresh", new Vector());
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Failed to refresh server", e);
                System.exit(1);
            }
        }
        if (cmd.hasOption("g")) {
            try {
                admin = new XmlRpcClient(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/DartServer/Command/"));
                String o = (String)admin.execute("Administration.getStatus", new Vector());
                logger.info("Status: " + o);
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Failed to get project status", e);
                System.exit(1);
            }
        }
        for (int i = 1; i < files.length; ++i) {
            try {
                byte[] Data = new byte[32000];
                File inputfile = new File(files[i]);
                logger.info("Length: " + inputfile.length());
                if (inputfile.length() > 0xA00000L) {
                    long l = (long)((double)inputfile.length() / 1048576.0);
                    logger.warn("Skipping " + inputfile.toString() + " Length: " + l + "M");
                    continue;
                }
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputfile));
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                FilterOutputStream out = null;
                out = inputfile.getName().endsWith(".gz") ? new BufferedOutputStream(bytes) : new GZIPOutputStream(bytes);
                while (true) {
                    int bytesRead = 0;
                    bytesRead = ((InputStream)in).read(Data);
                    if (bytesRead == -1) break;
                    ((OutputStream)out).write(Data, 0, bytesRead);
                }
                if (out instanceof GZIPOutputStream) {
                    ((GZIPOutputStream)out).finish();
                }
                Vector<byte[]> params = new Vector<byte[]>();
                params.addElement(bytes.toByteArray());
                client.execute("Submit.put", params);
                ((InputStream)in).close();
                continue;
            }
            catch (Exception e) {
                logger.error("Failed to call Dart with file: " + files[i], e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

