/*
 * Decompiled with CFR 0.152.
 */
package dart.server;

import dart.server.CommandManager;
import dart.server.Database;
import dart.server.Server;
import dart.server.ServletManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpServer;

public class Container {
    static Logger logger = Logger.getLogger(class$dart$server$Container == null ? (class$dart$server$Container = Container.class$("dart.server.Container")) : class$dart$server$Container);
    public static String UTCFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected String title = "Default";
    protected Database database = null;
    protected ServletManager servletManager = null;
    protected File baseDirectory = null;
    protected File temporaryDirectory = null;
    protected File htmlDirectory = null;
    protected File pluginsDirectory = null;
    protected File templatesDirectory = null;
    int uniqueFileIndex = 0;
    protected Server dartServer = null;
    protected CommandManager commandManager = null;
    static /* synthetic */ Class class$dart$server$Container;

    public void setTitle(String t) {
        this.title = t;
        logger.debug("title: " + this.title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setBaseDirectory(String d) {
        this.baseDirectory = new File(d);
        this.temporaryDirectory = new File(d, "Temporary");
        this.htmlDirectory = new File(d, "HTML");
        this.pluginsDirectory = new File(d, "Plugins");
        this.templatesDirectory = new File(d, "Templates");
        if (!this.temporaryDirectory.exists()) {
            this.temporaryDirectory.mkdir();
        }
        if (!this.htmlDirectory.exists()) {
            this.htmlDirectory.mkdir();
        }
        if (!this.pluginsDirectory.exists()) {
            this.pluginsDirectory.mkdir();
        }
        if (!this.templatesDirectory.exists()) {
            this.templatesDirectory.mkdir();
        }
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public File getHtmlDirectory() {
        return this.htmlDirectory;
    }

    public File getPluginsDirectory() {
        return this.pluginsDirectory;
    }

    public File getTemplates() {
        return this.templatesDirectory;
    }

    public File getUniqueFileInTemporaryDirectory(String suffix) {
        File file = this.temporaryDirectory;
        synchronized (file) {
            while (true) {
                File f;
                if (!(f = new File(this.temporaryDirectory, "File" + this.uniqueFileIndex + suffix)).exists()) {
                    return f;
                }
                ++this.uniqueFileIndex;
            }
        }
    }

    public static String generateSafeFileName(String name) {
        String n = name.replaceAll("[^0-9a-zA-Z-_+.:]", "_");
        return n.replaceAll(":", ".");
    }

    public void setDatabase(Database d) {
        this.database = d;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setCommandManager(CommandManager c) {
        this.commandManager = c;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public Connection getConnection() {
        return this.database.getConnection();
    }

    public HttpServer getHttpServer() {
        return this.dartServer.getHttpServer();
    }

    public void setServletManager(ServletManager m) {
        this.servletManager = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSQL(File schema) {
        StringWriter writer = new StringWriter();
        PrintWriter w = new PrintWriter(writer);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(schema));
            String b = null;
            while ((b = reader.readLine()) != null) {
                w.print(b.replaceAll("--.*", " "));
            }
            reader.close();
        }
        catch (Exception e) {
            logger.error(this.getTitle() + ": Failed to open schema\n", e);
            return;
        }
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            StringTokenizer tokenizer = new StringTokenizer(writer.toString(), ";");
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken().replace('\n', ' ').trim();
                if (s.length() == 0) continue;
                logger.debug(this.getTitle() + ": Found statement: " + s);
                statement.execute(s);
            }
        }
        catch (Exception e) {
            logger.error(this.getTitle() + ": Error initializing the database\n", e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

