/*
 * Decompiled with CFR 0.152.
 */
package dart.server;

import dart.server.Project;
import dart.server.Server;
import dart.server.wrap.CompletedTaskFinderBase;
import dart.server.wrap.CompletedTaskIterator;
import dart.server.wrap.CompletedTaskList;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.NotFoundHandler;

public class DefaultNotFoundHandler
extends NotFoundHandler {
    static Logger logger = Logger.getLogger(class$dart$server$Server == null ? (class$dart$server$Server = DefaultNotFoundHandler.class$("dart.server.Server")) : class$dart$server$Server);
    Server dartServer = null;
    static /* synthetic */ Class class$dart$server$Server;

    public void setDartServer(Server s) {
        this.dartServer = s;
    }

    public Server getDartServer() {
        return this.dartServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse res) throws HttpException, IOException {
        res.setContentType("text/html");
        PrintWriter out = new PrintWriter(res.getOutputStream());
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("date", Calendar.getInstance().getTime());
        root.put("projects", Server.projects);
        root.put("request", req);
        HashMap<String, Timestamp> activity = new HashMap<String, Timestamp>();
        Iterator it = Server.projects.entrySet().iterator();
        while (it.hasNext()) {
            Timestamp timestamp;
            Map.Entry entry = it.next();
            Project project = (Project)entry.getValue();
            Connection connection = project.getConnection();
            try {
                connection.setReadOnly(true);
            }
            catch (Exception e) {
                logger.error(project.getTitle() + ": Could not set connection to ReadOnly, possible security hole!", e);
            }
            JaxorContextImpl jaxorContext = new JaxorContextImpl(connection);
            CompletedTaskFinderBase taskFinder = new CompletedTaskFinderBase(jaxorContext);
            QueryParams params = new QueryParams();
            params.add("dart.server.task.XMLResultProcessor");
            CompletedTaskList taskList = taskFinder.query("select * from CompletedTask where Type=? order by ProcessedTime desc", params);
            CompletedTaskIterator lit = taskList.iterator();
            if (lit.hasNext()) {
                timestamp = lit.next().getProcessedTime();
                activity.put(project.getTitle(), timestamp);
            } else {
                timestamp = new Timestamp(0L);
                activity.put(project.getTitle(), timestamp);
            }
            try {
                connection.close();
            }
            catch (Exception e) {
                logger.error("Unable to close connection to database.");
            }
        }
        root.put("activity", activity);
        Configuration cfg = new Configuration();
        File resourcesDirectory = new File(this.dartServer.getBaseDirectory(), "Templates");
        cfg.setDirectoryForTemplateLoading(resourcesDirectory);
        Template template = cfg.getTemplate("DefaultNotFound.ftl");
        try {
            template.process(root, out);
        }
        catch (Exception e) {
        }
        finally {
            out.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

