/*
 * Decompiled with CFR 0.152.
 */
package dart.server;

import dart.server.Container;
import dart.server.DefaultNotFoundHandler;
import dart.server.Project;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.impl.DirectSchedulerFactory;
import qed.server.QED;

public class Server
extends Container {
    static Logger logger = Logger.getLogger(class$dart$server$Server == null ? (class$dart$server$Server = Server.class$("dart.server.Server")) : class$dart$server$Server);
    HttpServer httpServer = null;
    Scheduler scheduler = null;
    static HashMap projects = new HashMap();
    static HashMap qeds = new HashMap();
    static HashMap servers = new HashMap();
    HashMap projectNames = new HashMap();
    int httpPort = 8081;
    int schedulerThreadPoolSize = 10;
    boolean initializeProjectDB = false;
    boolean refreshProjectResources = false;
    boolean refreshServerResources = false;
    boolean dumpProject = false;
    static /* synthetic */ Class class$dart$server$Server;

    public void setInitializeProjectDB(boolean b) {
        this.initializeProjectDB = b;
    }

    public void setRefreshProjectResources(boolean b) {
        this.refreshProjectResources = b;
    }

    public void setDumpProject(boolean d) {
        this.dumpProject = d;
    }

    public void setRefreshServerResources(boolean b) {
        this.refreshServerResources = b;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public void setHttpPort(String p) {
        this.httpPort = Integer.parseInt(p);
    }

    public static Project getProject(String name) {
        return (Project)projects.get(name);
    }

    public static QED getQED(String name) {
        return (QED)qeds.get(name);
    }

    public static Server getServer(String name) {
        return (Server)servers.get(name);
    }

    public void doShutdown() {
        logger.warn("Starting shutdown of Dart Server");
        try {
            logger.warn("Waiting for Scheduler to finish running jobs");
            this.scheduler.shutdown(true);
            logger.warn("Scheduler shutdown");
        }
        catch (Exception e) {
            logger.error("Failed to shutdown Scheduler", e);
        }
        Iterator i = projects.values().iterator();
        while (i.hasNext()) {
            Project p = (Project)i.next();
            try {
                logger.warn("Shutting down project " + p.getTitle());
                p.shutdown();
            }
            catch (Exception e) {
                logger.error("Failed to shutdown: " + p.getTitle(), e);
            }
        }
        try {
            logger.warn("Waiting for HTTP server shutdown");
            this.httpServer.stop(true);
            logger.warn("HTTP server shutdown");
        }
        catch (Exception e) {
            logger.error("Failed to shutdown HTTP server");
        }
        try {
            this.getDatabase().shutdown();
        }
        catch (Exception e) {
            logger.error(this.getTitle() + ": Failed to shutdown Database", e);
        }
        logger.warn("Dart Server Shutdown");
    }

    public void addProject(String path) {
        this.projectNames.put(path, path);
    }

    public void clearProjects() {
        this.projectNames.clear();
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean reallyStart) {
        System.setProperty("java.awt.headless", "true");
        if (this.refreshServerResources) {
            this.refreshResources();
        }
        try {
            this.getDatabase().start(this);
        }
        catch (Exception e) {
            logger.error("Failed to start database", e);
        }
        try {
            logger.info("Initializing Scheduler");
            DirectSchedulerFactory.getInstance().createVolatileSchduler(this.schedulerThreadPoolSize);
            this.scheduler = DirectSchedulerFactory.getInstance().getScheduler();
            logger.info("Scheduler initialized");
        }
        catch (Exception e) {
            logger.error("Failed to initialize scheduler: ", e);
            return;
        }
        try {
            logger.info("Initializing HTTP server");
            this.httpServer = new HttpServer();
            this.httpServer.setStatsOn(true);
            SocketListener listener = new SocketListener();
            listener.setPort(this.httpPort);
            this.httpServer.addListener(listener);
            logger.info("HTTP server initialized");
            HttpContext defaultContext = this.httpServer.getContext("/");
            defaultContext.setResourceBase(this.htmlDirectory.getAbsolutePath());
            DefaultNotFoundHandler defaultNotFoundHandler = new DefaultNotFoundHandler();
            defaultNotFoundHandler.setDartServer(this);
            defaultContext.addHandler(defaultNotFoundHandler);
            logger.info("Creating security constraint");
            SecurityConstraint security = new SecurityConstraint();
            security.setAuthenticate(false);
            security.setName("Dart.Administrator");
        }
        catch (Exception e) {
            logger.error("Failed to initialize HTTP server", e);
            System.exit(1);
        }
        try {
            HttpContext httpContext = this.httpServer.getContext("/DartServer/*");
            httpContext.setResourceBase(this.htmlDirectory.getAbsolutePath());
            this.servletManager.start(this, httpContext);
            ResourceHandler handler = new ResourceHandler();
            handler.setDirAllowed(true);
            handler.setAcceptRanges(true);
            httpContext.addHandler(handler);
        }
        catch (Exception e) {
            logger.error("Failed to initialize ServletManager", e);
            System.exit(1);
        }
        try {
            this.commandManager.start(this);
        }
        catch (Exception e) {
            logger.error("Failed to start CommandManager", e);
            System.exit(1);
        }
        Iterator i = this.projectNames.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            boolean isOK = false;
            try {
                Project p = Project.loadProject(name);
                if (p != null) {
                    projects.put(p.getTitle(), p);
                    p.start(this);
                    if (this.initializeProjectDB) {
                        p.initializeDatabase();
                    }
                    if (this.refreshProjectResources) {
                        p.refreshResources();
                    }
                    if (this.dumpProject) {
                        p.dumpProject();
                    }
                    isOK = true;
                }
            }
            catch (Exception e) {
                logger.error("Error starting project " + name, e);
            }
            if (isOK) continue;
            try {
                logger.info("Trying to load a QED");
                QED qed = QED.loadQED(name);
                if (qed == null) continue;
                qeds.put(qed.getTitle(), qed);
                qed.start(this);
                if (this.initializeProjectDB) {
                    qed.initializeDatabase();
                }
                if (this.refreshProjectResources) {
                    qed.refreshResources();
                }
                isOK = true;
            }
            catch (Exception e) {
                logger.error("Error starting qed " + name, e);
            }
        }
        try {
            logger.info("Starting Scheduler");
            this.scheduler.start();
            logger.info("Scheduler started");
        }
        catch (Exception e) {
            logger.error("Failed to start scheduler", e);
            System.exit(1);
        }
        try {
            logger.info("Starting HTTP server");
            this.httpServer.start();
            logger.info("HTTP server started");
        }
        catch (Exception e) {
            logger.error("Failed to start HTTP server", e);
            System.exit(1);
        }
        StringBuffer b = new StringBuffer("Dart Server started with Projects: ");
        Iterator pi = projects.keySet().iterator();
        while (pi.hasNext()) {
            b.append((String)pi.next() + " ");
        }
        logger.info(b.toString());
    }

    public static void generateSchema(String DBType, Writer out) {
        Server.generateSchema(DBType, out, "dart/Resources/Server/Schema.sql");
    }

    public static void generateSchema(String DBType, Writer out, String SchemaPath) {
        try {
            Configuration cfg = new Configuration();
            cfg.setClassForTemplateLoading(class$dart$server$Server == null ? (class$dart$server$Server = Server.class$("dart.server.Server")) : class$dart$server$Server, "/");
            Template template = cfg.getTemplate(SchemaPath);
            HashMap<String, String> root = new HashMap<String, String>();
            root.put("Type", DBType.toLowerCase());
            if (DBType.toLowerCase().equals("generic") || DBType.toLowerCase().equals("postgres")) {
                logger.debug("Found generic or Postgres");
                root.put("auto", "bigserial primary key");
                root.put("now", "'now'");
            } else if (DBType.toLowerCase().equals("derby")) {
                logger.debug("Found derby");
                root.put("auto", "bigint generated always as identity");
                root.put("now", "CURRENT_TIMESTAMP");
            }
            template.process(root, out);
            out.flush();
        }
        catch (Exception e) {
            logger.error("Faild to generate schema\n", e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createServer(String path, String db) throws Exception {
        File dir = new File(path).getAbsoluteFile();
        if (dir.exists()) {
            logger.error("Directory: " + path + " exists, can not create new server");
            throw new Exception("Directory: " + path + " exists, can not create new server");
        }
        String name = dir.getName();
        logger.info("Creating new Server: " + path + " " + name + " " + db);
        BufferedWriter outTemplate = null;
        try {
            logger.debug("Creating directory " + dir.toString());
            dir.mkdirs();
            Configuration cfg = new Configuration();
            cfg.setClassForTemplateLoading(class$dart$server$Server == null ? (class$dart$server$Server = Server.class$("dart.server.Server")) : class$dart$server$Server, "/");
            Template template = cfg.getTemplate("dart/Resources/Server/DartServerDefault.xml");
            outTemplate = new BufferedWriter(new FileWriter(new File(dir, "Server.xml")));
            HashMap<String, String> root = new HashMap<String, String>();
            root.put("ServerName", name);
            root.put("ServerDirectory", dir.toString());
            if (db != null) {
                root.put("Type", db.toLowerCase());
            } else {
                root.put("Type", "derby");
            }
            template.process(root, outTemplate);
            ((Writer)outTemplate).flush();
            if (db != null) {
                BufferedWriter out = new BufferedWriter(new FileWriter(new File(dir, "ServerSchema.sql")));
                Server.generateServerSchema(db, out);
            }
        }
        catch (Exception e) {
            logger.error("Error creating server", e);
        }
    }

    public static void generateServerSchema(String DBType, Writer out) {
        try {
            Configuration cfg = new Configuration();
            cfg.setClassForTemplateLoading(class$dart$server$Server == null ? (class$dart$server$Server = Server.class$("dart.server.Server")) : class$dart$server$Server, "/");
            Template template = cfg.getTemplate("dart/Resources/Server/ServerSchema.sql");
            HashMap<String, String> root = new HashMap<String, String>();
            root.put("Type", DBType.toLowerCase());
            if (DBType.toLowerCase().equals("generic") || DBType.toLowerCase().equals("postgres")) {
                logger.debug("Found generic or Postgres");
                root.put("auto", "serial");
                root.put("now", "'now'");
            } else if (DBType.toLowerCase().equals("derby")) {
                logger.debug("Configuring Dart server using derby");
                root.put("auto", "int generated always as identity");
                root.put("now", "CURRENT_TIMESTAMP");
            }
            template.process(root, out);
            out.flush();
        }
        catch (Exception e) {
            logger.error("Faild to generate schema\n", e);
            return;
        }
    }

    public static Server loadServer(String inPath) {
        logger.info("Loading Dart server from " + inPath);
        File path = new File(inPath);
        if (path.isDirectory()) {
            path = new File(path, "Server.xml");
        }
        Server server = null;
        try {
            URL rules = (class$dart$server$Server == null ? (class$dart$server$Server = Server.class$("dart.server.Server")) : class$dart$server$Server).getClassLoader().getResource("dart/Resources/Server/DartObjectCreationRules.xml");
            logger.debug("Found DartObjectCreationRules.xml at: " + rules);
            Digester digester = new Digester();
            digester.setRules(new ExtendedBaseRules());
            digester.addRuleSet(new FromXmlRuleSet(rules));
            logger.info("Processed rules, starting to parse");
            server = (Server)digester.parse(path);
            logger.info("Parsed to create server");
            servers.put(server.getTitle(), server);
        }
        catch (Exception e) {
            logger.error("Failed to create server", e);
        }
        return server;
    }

    public void initializeDatabase() {
        logger.info(this.getTitle() + ": initializing server database");
        File schema = new File(this.getBaseDirectory(), "ServerSchema.sql");
        if (!schema.exists()) {
            logger.error(this.getTitle() + ": Schema file: " + schema.getPath() + " does not exist");
            return;
        }
        this.executeSQL(schema);
    }

    public String getStatus() {
        StringWriter b = new StringWriter();
        PrintWriter out = new PrintWriter(b);
        out.println("DartServer status\n");
        try {
            out.println("Project Info");
            Iterator p = projects.values().iterator();
            while (p.hasNext()) {
                Project project = (Project)p.next();
                out.println(project.toString());
            }
            DecimalFormat format = new DecimalFormat("0.00");
            out.println("Memory: " + format.format((double)Runtime.getRuntime().totalMemory() / 1048576.0) + "M / " + format.format((double)Runtime.getRuntime().maxMemory() / 1048576.0) + "M\n");
            out.println("HTTP Server: ");
            out.println("\tConnections: " + this.httpServer.getConnections());
            out.println("\tAverage Connection Duration: " + this.httpServer.getConnectionsDurationAve());
            out.println("\tMax Connection Duration: " + this.httpServer.getConnectionsDurationMax());
            out.println("\tOpen Connections: " + this.httpServer.getConnectionsOpen());
            out.println("\tMax Open Connections: " + this.httpServer.getConnectionsOpenMax());
            out.println("\tAve Connection Requests: " + this.httpServer.getConnectionsRequestsAve());
            out.println("\tMax Connection Requests: " + this.httpServer.getConnectionsRequestsMax());
            out.println("\tConnections: " + this.httpServer.getConnections());
            out.println("Scheduler: " + this.scheduler.getMetaData().getSummary());
            out.println("Currently executing: " + this.scheduler.getCurrentlyExecutingJobs().size());
            out.println("Paused: " + this.scheduler.getPausedTriggerGroups());
            out.println("Triggers");
            String[] groups = this.scheduler.getTriggerGroupNames();
            for (int i = 0; i < groups.length; ++i) {
                String[] names = this.scheduler.getTriggerNames(groups[i]);
                for (int j = 0; j < names.length; ++j) {
                    Trigger trigger = this.scheduler.getTrigger(names[j], groups[i]);
                    out.println(trigger.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to get scheduler status", e);
        }
        return b.toString();
    }

    public void refreshResources() {
        if (!this.temporaryDirectory.exists()) {
            this.temporaryDirectory.mkdir();
        }
        if (!this.htmlDirectory.exists()) {
            this.htmlDirectory.mkdir();
        }
        if (!this.templatesDirectory.exists()) {
            this.templatesDirectory.mkdir();
        }
        if (!this.pluginsDirectory.exists()) {
            this.pluginsDirectory.mkdir();
        }
        URL resourceRootURL = (class$dart$server$Server == null ? (class$dart$server$Server = Server.class$("dart.server.Server")) : class$dart$server$Server).getClassLoader().getResource("dart/Resources/Server/Style.css");
        logger.info("Default server resources root path is " + resourceRootURL.toString());
        FileObject dest = null;
        FileObject src = null;
        FileObject templates = null;
        try {
            FileSystemManager fsManager = VFS.getManager();
            logger.debug("New Resource Root:" + resourceRootURL.toString().replaceAll("jar:file:", "jar://"));
            logger.debug("Resource Root:" + resourceRootURL.toString());
            src = fsManager.resolveFile(resourceRootURL.toString()).getParent();
            logger.debug("Src exists: " + src.exists());
            File destinationDirectory = new File(this.htmlDirectory, "Resources").getAbsoluteFile();
            dest = fsManager.resolveFile(destinationDirectory.toString());
            templates = dest.getParent().getParent().resolveFile("Templates");
            logger.debug("src: " + src.toString());
            logger.debug("dest: " + dest.toString());
            logger.debug("templates: " + templates.toString());
            logger.debug("Copy Templates");
            if (!src.resolveFile("Templates").exists()) {
                logger.debug("Could not find Templates in src");
            }
            templates.copyFrom(src.resolveFile("Templates"), new AllFileSelector());
            logger.debug("Copy Resources");
            dest.copyFrom(src, new FileSelector(){

                public boolean includeFile(FileSelectInfo info) throws Exception {
                    return !info.getFile().getName().getBaseName().equals("Templates");
                }

                public boolean traverseDescendents(FileSelectInfo info) throws Exception {
                    return !info.getFile().getName().getBaseName().equals("Templates");
                }
            });
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to refresh resources", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

