/*
 * Decompiled with CFR 0.152.
 */
package dart.server;

import dart.server.Project;
import dart.server.track.Track;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.SubmissionList;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class TrackManager {
    static Logger logger = Logger.getLogger(class$dart$server$TrackManager == null ? (class$dart$server$TrackManager = TrackManager.class$("dart.server.TrackManager")) : class$dart$server$TrackManager);
    Project project;
    HashMap map = new HashMap();
    String defaultTrack;
    static /* synthetic */ Class class$dart$server$TrackManager;

    public void addTrack(Track t) {
        logger.debug("Adding Track: " + t);
        this.map.put(t.getName(), t);
    }

    public void setDefaultTrack(String s) {
        this.defaultTrack = s;
    }

    public void start(Project p) throws Exception {
        this.project = p;
        logger.debug(this.project.getTitle() + ": Starting TrackManager");
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            Track track = (Track)i.next();
            track.setProject(this.project);
        }
    }

    public int getTrackId(Timestamp ts, String trackName) {
        return ((Track)this.map.get(trackName)).getTrackId(ts);
    }

    public int[] getTrackIds(Timestamp ts) {
        int[] r = new int[this.map.size()];
        Iterator i = this.map.values().iterator();
        int idx = 0;
        while (i.hasNext()) {
            Track track = (Track)i.next();
            r[idx] = track.getTrackId(ts);
            ++idx;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkSubmission(int SubmissionId) throws Exception {
        Connection connection = this.project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        try {
            SubmissionFinderBase submissionFinder = new SubmissionFinderBase(session);
            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(SubmissionId));
            SubmissionList l = submission.selectLastSubmissions();
            if (l.size() > 0) {
                SubmissionEntity lastEntity = l.get(0);
                lastEntity.setNextSubmissionId(submission.getSubmissionId());
                submission.setLastSubmissionId(lastEntity.getSubmissionId());
            }
            if ((l = submission.selectNextSubmissions()).size() > 0) {
                SubmissionEntity nextEntity = l.get(0);
                nextEntity.setLastSubmissionId(submission.getSubmissionId());
                submission.setNextSubmissionId(nextEntity.getSubmissionId());
            }
            session.commit();
        }
        catch (Exception e) {
            logger.error("Failed to link Submission: " + SubmissionId);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception ex) {}
        }
    }

    public void placeSubmission(int SubmissionId, String trackName) throws Exception {
        this.linkSubmission(SubmissionId);
        Track track = (Track)this.map.get(trackName);
        if (track == null) {
            track = (Track)this.map.get(this.defaultTrack);
        }
        if (track == null) {
            String e = this.project.getTitle() + ": not able to place submission, Track " + trackName + " was not found";
            logger.error(e);
            throw new Exception(e);
        }
        if (!track.placeSubmission(SubmissionId)) {
            String e = this.project.getTitle() + ": failed to place submission, SubmissionId " + SubmissionId;
            logger.error(e);
            throw new Exception(e);
        }
    }

    public void shutdown() throws Exception {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

