/*
 * Decompiled with CFR 0.152.
 */
package dart.server.servlet;

import dart.server.Project;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcServer;

public class ResultServlet
extends HttpServlet {
    static Logger logger = Logger.getLogger(class$dart$server$servlet$ResultServlet == null ? (class$dart$server$servlet$ResultServlet = ResultServlet.class$("dart.server.servlet.ResultServlet")) : class$dart$server$servlet$ResultServlet);
    String servicename = null;
    Project project = null;
    XmlRpcServer xmlrpc = null;
    boolean deleteWhenDigested = false;
    static /* synthetic */ Class class$dart$server$servlet$ResultServlet;

    public ResultServlet() {
        logger.info("Creating ResultServlet");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("Handling request");
        byte[] result = this.xmlrpc.execute(request.getInputStream());
        response.setContentType("text/xml");
        response.setContentLength(result.length);
        response.getOutputStream().write(result);
        response.getOutputStream().flush();
        logger.debug("Handled request: " + result);
    }

    public void setServiceName(String name) {
        this.servicename = name;
    }

    public void start(Project p) throws Exception {
        this.project = p;
        this.xmlrpc = new XmlRpcServer();
        if (this.servicename == null) {
            this.servicename = p.getTitle();
        }
        this.xmlrpc.addHandler(this.servicename, new ResultHandler());
    }

    public void setDeleteWhenDigested(String i) {
        logger.debug("Setting DeleteWhenDigested to " + i);
        this.deleteWhenDigested = Boolean.valueOf(i);
        logger.debug("Set DeleteWhenDigested to " + this.deleteWhenDigested);
    }

    public void shutdown() throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ResultHandler {
        public void put(byte[] f) {
            File tmp = ResultServlet.this.project.getUniqueFileInTemporaryDirectory(".xml.gz");
            try {
                int Magic = f[0] & 0xFF | f[1] << 8 & 0xFF00;
                OutputStream out = new FileOutputStream(tmp);
                if (Magic != 35615) {
                    logger.debug(ResultServlet.this.project.getTitle() + ": Data was not gzipped, gzipping during save");
                    out = new GZIPOutputStream(out);
                }
                ((OutputStream)out).write(f);
                out.flush();
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                logger.error(ResultServlet.this.project.getTitle() + ": Failed to write", e);
            }
            Properties prop = new Properties();
            try {
                prop.setProperty("URL", tmp.toURL().toString());
                prop.setProperty("DeleteWhenDigested", Boolean.toString(ResultServlet.this.deleteWhenDigested));
            }
            catch (Exception e) {
                logger.error(ResultServlet.this.project.getTitle() + ": Failed to convert file to URL", e);
            }
            ResultServlet.this.project.queueTask("dart.server.task.XMLResultProcessor", prop, 5);
        }

        public void refresh() {
            ResultServlet.this.project.refreshResources();
        }
    }
}

