/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.task.Task;
import dart.server.wrap.CompletedTaskEntity;
import dart.server.wrap.CompletedTaskFinderBase;
import dart.server.wrap.TaskQueueEntity;
import dart.server.wrap.TaskQueueFinderBase;
import dart.server.wrap.TaskQueueIterator;
import dart.server.wrap.TaskQueueList;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import org.apache.log4j.Logger;

public class QueueManager
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$QueueManager == null ? (class$dart$server$task$QueueManager = QueueManager.class$("dart.server.task.QueueManager")) : class$dart$server$task$QueueManager);
    static /* synthetic */ Class class$dart$server$task$QueueManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Project project, Properties properties) throws Exception {
        int maxTasks = -1;
        int tasks = 0;
        int minPriority = 0;
        int maxPriority = 100;
        maxTasks = Integer.parseInt(properties.getProperty("MaxTasks", "-1"));
        Connection connection = project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        TaskQueueFinderBase finder = new TaskQueueFinderBase(session);
        CompletedTaskFinderBase completedTaskFinder = new CompletedTaskFinderBase(session);
        QueryParams q = new QueryParams();
        q.add(minPriority);
        q.add(maxPriority);
        while (true) {
            CompletedTaskEntity CompletedTask;
            Object var21_21;
            TaskQueueList list;
            TaskQueueIterator i;
            if (!(i = (list = finder.find("where priority >= ? and priority <= ? order by priority, taskid", q)).iterator()).hasNext()) {
                logger.debug(project.getTitle() + ": TaskQueue is empty");
                break;
            }
            if (tasks >= maxTasks) {
                logger.debug(project.getTitle() + ": Reached maximum tasks");
                break;
            }
            logger.debug(project.getTitle() + ": Processing task " + ++tasks + " / " + maxTasks);
            String Status = "completed";
            String Result2 = "";
            TaskQueueEntity task = i.next();
            logger.debug(project.getTitle() + ": Found: " + task.getType() + " Priority: " + task.getPriority() + "\nProperties: " + task.getProperties());
            boolean record = true;
            try {
                try {
                    Properties subTaskProperties = new Properties();
                    subTaskProperties.load(new ByteArrayInputStream(task.getProperties().getBytes()));
                    record = Boolean.valueOf(subTaskProperties.getProperty("RecordCompletedTask", "true"));
                    Task subtask = (Task)Class.forName(task.getType()).newInstance();
                    subtask.execute(project, subTaskProperties);
                    logger.debug(project.getTitle() + ": Task completed");
                }
                catch (Exception e) {
                    logger.error(project.getTitle() + ": Failed to create or execute queued task", e);
                    Status = "failed";
                    Result2 = e.toString();
                    var21_21 = null;
                    if (record) {
                        CompletedTask = completedTaskFinder.newInstance(task.getTaskId());
                        CompletedTask.setPriority(task.getPriority());
                        CompletedTask.setStatus(Status);
                        CompletedTask.setType(task.getType());
                        CompletedTask.setProperties(task.getProperties());
                        CompletedTask.setResult(Result2);
                    }
                    task.delete();
                    session.commit();
                    continue;
                }
                var21_21 = null;
                if (record) {
                    CompletedTask = completedTaskFinder.newInstance(task.getTaskId());
                    CompletedTask.setPriority(task.getPriority());
                    CompletedTask.setStatus(Status);
                    CompletedTask.setType(task.getType());
                    CompletedTask.setProperties(task.getProperties());
                    CompletedTask.setResult(Result2);
                }
            }
            catch (Throwable throwable) {
                var21_21 = null;
                if (record) {
                    CompletedTask = completedTaskFinder.newInstance(task.getTaskId());
                    CompletedTask.setPriority(task.getPriority());
                    CompletedTask.setStatus(Status);
                    CompletedTask.setType(task.getType());
                    CompletedTask.setProperties(task.getProperties());
                    CompletedTask.setResult(Result2);
                }
                task.delete();
                session.commit();
                throw throwable;
            }
            task.delete();
            session.commit();
        }
        connection.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

