/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.task.Task;
import dart.server.wrap.ClientEntity;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.SubmissionList;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import org.apache.log4j.Logger;

public class ReportTask
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$ReportTask == null ? (class$dart$server$task$ReportTask = ReportTask.class$("dart.server.task.ReportTask")) : class$dart$server$task$ReportTask);
    static /* synthetic */ Class class$dart$server$task$ReportTask;

    public void execute(Project project, Properties properties) throws Exception {
        SubmissionFinderBase submissionFinder;
        String type = properties.getProperty("Type");
        String templateName = properties.getProperty("Template");
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(class$dart$server$task$ReportTask == null ? (class$dart$server$task$ReportTask = ReportTask.class$("dart.server.task.ReportTask")) : class$dart$server$task$ReportTask, "/");
        Template template = cfg.getTemplate("Templates" + templateName);
        File output = null;
        HashMap<String, Object> root = new HashMap<String, Object>();
        Connection connection = project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        if (type.equals("Submission")) {
            submissionFinder = new SubmissionFinderBase(session);
            try {
                SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(properties.getProperty("SubmissionId")));
                root.put("Submission", submission);
                ClientEntity client = submission.getClientEntity();
                logger.debug("Found client: " + client);
                root.put("Client", client);
                output = new File(project.getBaseDirectory() + File.separator + "HTML" + File.separator + client.getSite() + File.separator + client.getBuildName() + File.separator + submission.getTimeStamp() + "-" + submission.getType() + File.separator + "Submission.html");
            }
            catch (Exception e) {
                logger.error(project.getTitle() + ": Error", e);
                throw e;
            }
        } else if (type.equals("Dashboard")) {
            submissionFinder = new SubmissionFinderBase(session);
            java.util.Date date = new SimpleDateFormat().parse(properties.getProperty("Date"));
            logger.info(project.getTitle() + ": Parsed date " + date);
            String ts = new SimpleDateFormat("yyyyMMdd").format(date);
            root.put("Date", date);
            root.put("Timestamp", ts);
            output = new File(project.getBaseDirectory() + File.separator + "HTML" + File.separator + "Dashboard" + File.separator + ts + File.separator + "Dashboard.html");
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            java.util.Date start = cal.getTime();
            cal = Calendar.getInstance();
            cal.setTime(start);
            cal.add(11, 24);
            java.util.Date end = cal.getTime();
            QueryParams params = new QueryParams();
            Date d1 = new Date(start.getTime());
            Date d2 = new Date(end.getTime());
            params.add(d1);
            params.add(d2);
            logger.debug(project.getTitle() + ": Select from " + d1 + " to " + d2);
            SubmissionList list = submissionFinder.find("where timestamp >= ? and timestamp < ?", params);
            logger.debug(project.getTitle() + ": Found " + list.toArray().length + " builds for the dashboard");
            logger.debug(project.getTitle() + ": Build Timestamp" + list.toArray()[0].getTimeStamp());
            root.put("Submissions", list);
        } else {
            logger.warn(project.getTitle() + ": Not ready to do other dashboards");
            return;
        }
        try {
            output.getParentFile().mkdirs();
            BufferedWriter out = new BufferedWriter(new FileWriter(output));
            template.process(root, out);
            ((Writer)out).flush();
        }
        catch (Exception e) {
            logger.error(project.getTitle() + ": Failed to process template", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

