/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.task.Task;
import dart.server.wrap.ResultEntity;
import dart.server.wrap.ResultFinderBase;
import dart.server.wrap.ResultList;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestFinderBase;
import dart.server.wrap.TestIterator;
import java.sql.Connection;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class SummarizeBuildTask
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$SummarizeBuildTask == null ? (class$dart$server$task$SummarizeBuildTask = SummarizeBuildTask.class$("dart.server.task.SummarizeBuildTask")) : class$dart$server$task$SummarizeBuildTask);
    static /* synthetic */ Class class$dart$server$task$SummarizeBuildTask;

    public void execute(Project project, Properties properties) throws Exception {
        String SubmissionId = properties.getProperty("SubmissionId");
        Connection connection = project.getConnection();
        try {
            ResultEntity result;
            JaxorContextImpl session = new JaxorContextImpl(connection);
            SubmissionFinderBase submissionFinder = new SubmissionFinderBase(session);
            TestFinderBase testFinder = new TestFinderBase(session);
            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(SubmissionId));
            TestEntity build = submission.selectTest(".Build");
            if (build == null) {
                logger.debug(project.getTitle() + ": No Build info found");
                return;
            }
            int Errors = 0;
            int Warnings = 0;
            TestIterator children = build.selectChildren().iterator();
            while (children.hasNext()) {
                TestEntity child = children.next();
                if (child.getQualifiedName().matches(".*Error.*")) {
                    logger.info(project.getTitle() + ": Found error: " + child.getQualifiedName());
                    ++Errors;
                }
                if (!child.getQualifiedName().matches(".*Warning.*")) continue;
                logger.info(project.getTitle() + ": Found warning: " + child.getQualifiedName());
                ++Warnings;
            }
            ResultFinderBase resultFinder = new ResultFinderBase(session);
            ResultList results = build.selectResult("ErrorCount");
            if (results.toArray().length > 0) {
                result = results.toArray()[0];
            } else {
                result = resultFinder.newInstance();
                result.setTestId(build.getTestId());
                result.setType("numeric/integer");
                result.setName("ErrorCount");
                result.setValue(Integer.toString(Errors));
            }
            results = build.selectResult("WarningCount");
            if (results.toArray().length > 0) {
                result = results.toArray()[0];
            } else {
                result = resultFinder.newInstance();
                result.setTestId(build.getTestId());
                result.setType("numeric/integer");
                result.setName("WarningCount");
                result.setValue(Integer.toString(Warnings));
            }
            session.commit();
            session.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            connection.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

