/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.task.Task;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestFinderBase;
import dart.server.wrap.TestIterator;
import java.sql.Connection;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class SummarizeCoverage
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$SummarizeCoverage == null ? (class$dart$server$task$SummarizeCoverage = SummarizeCoverage.class$("dart.server.task.SummarizeCoverage")) : class$dart$server$task$SummarizeCoverage);
    JaxorContextImpl session;
    static /* synthetic */ Class class$dart$server$task$SummarizeCoverage;

    protected void rollup(TestEntity coverage) {
        int testedLines = 0;
        int untestedLines = 0;
        TestIterator children = coverage.selectChildren().iterator();
        while (children.hasNext()) {
            TestEntity child = children.next();
            this.rollup(child);
            Object LOCTested = child.getResultValueAsObject("LOCTested", null);
            Object LOCUnTested = child.getResultValueAsObject("LOCUnTested", null);
            if (LOCTested == null || LOCUnTested == null) continue;
            testedLines += ((Integer)LOCTested).intValue();
            untestedLines += ((Integer)LOCUnTested).intValue();
            logger.debug("Incremented by " + (Integer)LOCTested + " / " + (Integer)LOCUnTested + " from test: " + child.getName());
        }
        try {
            if (coverage.getStatus().equals("m")) {
                coverage.setResult("LOCTested", "numeric/integer", Integer.toString(testedLines));
                coverage.setResult("LOCUnTested", "numeric/integer", Integer.toString(untestedLines));
                int totalLines = testedLines + untestedLines;
                if (totalLines > 0) {
                    coverage.setResult("PercentCoverage", "numeric/float", Float.toString((float)testedLines / (float)totalLines * 100.0f));
                    coverage.setResult("CoverageMetric", "numeric/float", Float.toString((float)(testedLines + 10) / (float)(totalLines + 10)));
                } else {
                    coverage.setResult("PercentCoverage", "numeric/float", "0.0");
                    coverage.setResult("CoverageMetric", "numeric/float", "1.0");
                }
                logger.debug("Setting coverage for " + coverage.getName() + " to " + testedLines + " / " + untestedLines);
                coverage.getJaxorContext().commit();
            }
        }
        catch (Exception e) {
            logger.error("Caught exception updating LOCTested/LOCUnTested", e);
        }
    }

    public void execute(Project project, Properties properties) throws Exception {
        String SubmissionId = properties.getProperty("SubmissionId");
        Connection connection = project.getConnection();
        logger.debug("Starting Coverage Summary for SubmissionId: " + SubmissionId);
        try {
            this.session = new JaxorContextImpl(connection);
            SubmissionFinderBase submissionFinder = new SubmissionFinderBase(this.session);
            TestFinderBase testFinder = new TestFinderBase(this.session);
            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(SubmissionId));
            TestEntity coverage = submission.selectTest(".Coverage");
            if (coverage == null) {
                logger.debug(project.getTitle() + ": No Coverage info found");
                return;
            }
            this.rollup(coverage);
            this.session.commit();
            this.session.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            connection.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

