/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.TestProcessor;
import dart.server.task.Task;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.log4j.Logger;

public class XMLResultProcessor
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$XMLResultProcessor == null ? (class$dart$server$task$XMLResultProcessor = XMLResultProcessor.class$("dart.server.task.XMLResultProcessor")) : class$dart$server$task$XMLResultProcessor);
    static /* synthetic */ Class class$dart$server$task$XMLResultProcessor;
    static /* synthetic */ Class class$dart$server$Project;

    /*
     * Loose catch block
     */
    public void execute(Project project, Properties properties) throws Exception {
        block15: {
            URL file = new URL(properties.getProperty("URL"));
            URL rules = (class$dart$server$Project == null ? (class$dart$server$Project = XMLResultProcessor.class$("dart.server.Project")) : class$dart$server$Project).getClassLoader().getResource("dart/Resources/Server/TestProcessorRules.xml");
            boolean deleteWhenDigested = Boolean.valueOf(properties.getProperty("DeleteWhenDigested", "false"));
            Digester digester = DigesterLoader.createDigester(rules);
            logger.debug("Processed rules, starting to parse");
            TestProcessor t = new TestProcessor(project);
            t.setMaxTests(Integer.parseInt(project.getProperties().getProperty("MaxTestsPerSubmission", "-1")));
            digester.push(t);
            project.incrementStatistic("Submissions");
            InputStream input = file.openStream();
            if (!properties.containsKey("UnCompressed")) {
                input = new GZIPInputStream(input);
            } else {
                logger.debug(project.getTitle() + ": uncompressed " + file);
                input = new BufferedInputStream(input);
            }
            boolean hasError = false;
            try {
                digester.parse(input);
                Object var12_10 = null;
                t.processDelayed();
                t.queueSummary();
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                t.processDelayed();
                t.queueSummary();
                logger.debug(project.getTitle() + ": DeleteWhenDigested " + deleteWhenDigested);
                if (deleteWhenDigested & !hasError) {
                    logger.debug(project.getTitle() + ": Attempting to delete " + file.toString());
                    if (file.toString().startsWith("file:")) {
                        File f = new File(new URI(file.toString()));
                        f.delete();
                    }
                } else {
                    try {
                        File f = new File(new URI(file.toString()));
                        File newFile = new File(f.getParentFile(), "Failed" + File.separator + f.getName());
                        logger.debug(project.getTitle() + ": Moving " + f.toString() + " to " + newFile.toString());
                        f.renameTo(newFile);
                    }
                    catch (Exception e) {
                        logger.error("Failed to move " + file + " to Failed directory", e);
                    }
                }
                throw throwable;
            }
            logger.debug(project.getTitle() + ": DeleteWhenDigested " + deleteWhenDigested);
            if (deleteWhenDigested & !hasError) {
                logger.debug(project.getTitle() + ": Attempting to delete " + file.toString());
                if (file.toString().startsWith("file:")) {
                    File f = new File(new URI(file.toString()));
                    f.delete();
                }
            } else {
                try {
                    File f = new File(new URI(file.toString()));
                    File newFile = new File(f.getParentFile(), "Failed" + File.separator + f.getName());
                    logger.debug(project.getTitle() + ": Moving " + f.toString() + " to " + newFile.toString());
                    f.renameTo(newFile);
                }
                catch (Exception e) {
                    logger.error("Failed to move " + file + " to Failed directory", e);
                }
            }
            break block15;
            {
                catch (Exception e) {
                    logger.error(project.getTitle() + ": Failed to parse file: " + file, e);
                    hasError = true;
                    throw e;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

