/*
 * Decompiled with CFR 0.152.
 */
package dart.server.track;

import dart.server.Project;
import dart.server.track.Track;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.TrackEntity;
import dart.server.wrap.TrackFinderBase;
import dart.server.wrap.TrackResultSet;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.mappers.TimestampMapper;
import org.apache.log4j.Logger;

public class TemporalTrack
implements Track {
    static Logger logger = Logger.getLogger(class$dart$server$track$TemporalTrack == null ? (class$dart$server$track$TemporalTrack = TemporalTrack.class$("dart.server.track.TemporalTrack")) : class$dart$server$track$TemporalTrack);
    double duration = 24.0;
    String name = "Track";
    Date start;
    Project project;
    DateFormat format = DateFormat.getDateTimeInstance(2, 2);
    static /* synthetic */ Class class$dart$server$track$TemporalTrack;

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setDuration(String d) {
        this.duration = Double.parseDouble(d);
    }

    public void setStart(String s) {
        int i;
        int[] styles = new int[]{3, 2, 1, 0};
        block6: for (i = 0; i < styles.length; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                try {
                    this.start = DateFormat.getDateTimeInstance(styles[i], styles[j]).parse(s);
                    continue block6;
                }
                catch (Exception e) {
                    logger.debug("Did not parse date/time: " + i + ", " + j);
                    continue;
                }
            }
        }
        if (this.start == null) {
            for (i = 0; i < styles.length; ++i) {
                try {
                    this.start = DateFormat.getDateInstance(styles[i]).parse(s);
                    break;
                }
                catch (Exception e) {
                    try {
                        this.start = DateFormat.getTimeInstance(styles[i]).parse(s);
                        break;
                    }
                    catch (Exception e2) {
                        continue;
                    }
                }
            }
        }
        if (this.start == null) {
            logger.error("TemporalTrack Failed to parse datetime: " + s);
        }
    }

    public void setProject(Project p) {
        this.project = p;
    }

    public int getTrackId(Timestamp ts) {
        int trackId = 0;
        Connection connection = this.project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        try {
            TrackEntity trackEntity;
            SubmissionFinderBase submissionFinder = new SubmissionFinderBase(session);
            TrackFinderBase trackFinder = new TrackFinderBase(session);
            Calendar trackStart = Calendar.getInstance();
            trackStart.setTime(this.start);
            Calendar submissionTime = Calendar.getInstance();
            submissionTime.setTime(ts);
            long d = (long)(this.duration * 3600000.0);
            long first = trackStart.getTimeInMillis() % d;
            long t = first + d * ((submissionTime.getTimeInMillis() - first) / d);
            Calendar submissionTrackStart = Calendar.getInstance();
            Calendar submissionTrackEnd = Calendar.getInstance();
            submissionTrackStart.setTimeInMillis(t);
            submissionTrackEnd.setTimeInMillis(t + d);
            Calendar zero = Calendar.getInstance();
            zero.setTimeInMillis(0L);
            logger.debug(this.project.getTitle() + ": Duration in millis: " + d + " first: " + first + " submission: " + submissionTrackStart.getTimeInMillis());
            logger.debug(this.project.getTitle() + ": zero [" + this.format.format(zero.getTime()) + "]");
            logger.debug(this.project.getTitle() + ": TrackStart [" + this.format.format(trackStart.getTime()) + "] SubmissionTime [" + this.format.format(submissionTime.getTime()) + "] TrackStart [" + this.format.format(submissionTrackStart.getTime()) + "] TrackEnd [" + this.format.format(submissionTrackEnd.getTime()) + "]");
            TrackResultSet rs = trackFinder.selectIntersectingResultSet(this.name, ts, ts);
            if (rs.hasNext()) {
                trackEntity = rs.next();
                logger.debug(this.project.getTitle() + ": Found track: " + trackEntity.getTrackId());
            } else {
                logger.debug(this.project.getTitle() + ": Creating new track");
                trackEntity = trackFinder.newInstance();
                trackEntity.setName(this.name);
                trackEntity.setStartTime(new Timestamp(submissionTrackStart.getTimeInMillis()));
                trackEntity.setEndTime(new Timestamp(submissionTrackEnd.getTimeInMillis()));
                session.commit();
                rs = trackFinder.selectIntersectingResultSet(this.name, ts, ts);
                if (!rs.hasNext()) {
                    throw new Exception(this.project.getTitle() + ": Failed to create new Track!!!");
                }
                trackEntity = rs.next();
                QueryParams params = new QueryParams();
                params.add(this.name);
                params.add(new TimestampMapper(), (Object)trackEntity.getStartTime());
                rs = trackFinder.findResultSet("where name = ? and EndTime <= ? order by EndTime desc", params);
                if (rs.hasNext()) {
                    TrackEntity lastTrack = rs.next();
                    lastTrack.setNextTrackId(trackEntity.getTrackId());
                    trackEntity.setLastTrackId(lastTrack.getTrackId());
                    logger.debug(this.project.getTitle() + ": setting last track to " + lastTrack.getTrackId() + " end time " + lastTrack.getEndTime());
                    session.commit();
                }
                params = new QueryParams();
                params.add(this.name);
                params.add(new TimestampMapper(), (Object)trackEntity.getEndTime());
                rs = trackFinder.findResultSet("where name = ? and StartTime >= ? order by StartTime asc", params);
                if (rs.hasNext()) {
                    TrackEntity nextTrack = rs.next();
                    nextTrack.setLastTrackId(trackEntity.getTrackId());
                    trackEntity.setNextTrackId(nextTrack.getTrackId());
                    logger.debug(this.project.getTitle() + ": setting next track to " + nextTrack.getTrackId() + " start time " + nextTrack.getStartTime());
                    session.commit();
                }
            }
            trackId = trackEntity.getTrackId().intValue();
        }
        catch (Exception e) {
            logger.error(this.project.getTitle() + ": Failed to find track", e);
        }
        try {
            connection.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return trackId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean placeSubmission(int submissionId) {
        logger.info(this.project.getTitle() + ": placeSubmission");
        Connection connection = this.project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        try {
            SubmissionFinderBase submissionFinder = new SubmissionFinderBase(session);
            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(submissionId));
            int trackId = this.getTrackId(submission.getTimeStamp());
            logger.debug(this.project.getTitle() + ": Setting submission TrackId " + trackId);
            submission.setTrackId(new Long(trackId));
            session.commit();
        }
        catch (Exception e) {
            logger.error(this.project.getTitle() + ": Error getting placing Submission", e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {}
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TemporalTrack: " + this.name + " " + this.start + " " + this.duration);
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

