/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.cache.TemplateCache;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ParseException;
import freemarker.core.StringLiteral;
import freemarker.core.TemplateElement;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;
import java.io.IOException;

final class Include
extends TemplateElement {
    private Expression includedTemplateName;
    private Expression encodingExp;
    private Expression parseExp;
    private String encoding;
    private boolean parse;
    private final String templatePath;

    Include(Template template, Expression includedTemplateName, Expression encodingExp, Expression parseExp) {
        String templatePath1 = template.getName();
        int lastSlash = templatePath1.lastIndexOf(47);
        this.templatePath = lastSlash == -1 ? "" : templatePath1.substring(0, lastSlash + 1);
        this.includedTemplateName = includedTemplateName;
        if (encodingExp instanceof StringLiteral) {
            this.encoding = encodingExp.toString();
            this.encoding = this.encoding.substring(1, this.encoding.length() - 1);
        } else {
            this.encodingExp = encodingExp;
        }
        if (parseExp == null || parseExp == TemplateBooleanModel.TRUE) {
            this.parse = true;
        } else if (parseExp == TemplateBooleanModel.FALSE) {
            this.parse = false;
        } else if (parseExp instanceof StringLiteral) {
            this.parse = StringUtil.getYesNo(parseExp.toString());
        } else {
            this.parseExp = parseExp;
        }
    }

    void accept(Environment env) throws TemplateException, IOException {
        Template includedTemplate;
        String templateNameString = this.includedTemplateName.getStringValue(env);
        if (templateNameString == null) {
            String msg = "Error " + this.getStartLocation() + "The expression " + this.includedTemplateName + " is undefined.";
            throw new InvalidReferenceException(msg, env);
        }
        String enc = this.encoding;
        if (this.encoding == null && this.encodingExp != null) {
            enc = this.encodingExp.getStringValue(env);
        }
        boolean parse = this.parse;
        if (this.parseExp != null) {
            TemplateModel tm = this.parseExp.getAsTemplateModel(env);
            if (tm == null) {
                if (env.isClassicCompatible()) {
                    parse = false;
                } else {
                    Include.assertNonNull(tm, this.parseExp, env);
                }
            }
            parse = tm instanceof TemplateScalarModel ? this.getYesNo(EvaluationUtil.getString((TemplateScalarModel)tm, this.parseExp, env)) : this.parseExp.isTrue(env);
        }
        try {
            templateNameString = TemplateCache.getFullTemplatePath(env, this.templatePath, templateNameString);
            includedTemplate = env.getTemplateForInclusion(templateNameString, enc, parse);
        }
        catch (ParseException pe) {
            String msg = "Error parsing included template " + templateNameString;
            throw new TemplateException(msg, pe, env);
        }
        catch (IOException ioe) {
            String msg = "Error reading included file " + templateNameString;
            throw new TemplateException(msg, ioe, env);
        }
        env.include(includedTemplate);
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<#include ");
        buf.append(this.includedTemplateName);
        if (this.encoding != null) {
            buf.append(" encoding=\"");
            buf.append(this.encodingExp.getCanonicalForm());
            buf.append("\"");
        }
        if (!this.parse) {
            buf.append(" parse=false");
        }
        buf.append("/>");
        return buf.toString();
    }

    public String getDescription() {
        return "include " + this.includedTemplateName;
    }

    private boolean getYesNo(String s) throws ParseException {
        try {
            return StringUtil.getYesNo(s);
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException("Error " + this.getStartLocation() + "\nValue of include parse parameter " + "must be boolean or one of these strings: " + "\"n\", \"no\", \"f\", \"false\", \"y\", \"yes\", \"t\", \"true\"" + "\nFound: " + this.parseExp, this.parseExp);
        }
    }
}

