/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jython;

import freemarker.ext.jython.JythonHashModel;
import freemarker.ext.jython.JythonModel;
import freemarker.ext.jython.JythonNumberModel;
import freemarker.ext.jython.JythonSequenceModel;
import freemarker.ext.util.ModelCache;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.OptimizerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;

public class JythonWrapper
implements ObjectWrapper {
    public static final JythonWrapper INSTANCE = new JythonWrapper();
    private final ModelCache modelCache = new ModelCache(this);
    private boolean attributesShadowItems = true;
    static /* synthetic */ Class class$java$lang$Object;

    public void setUseCache(boolean useCache) {
        this.modelCache.setUseCache(useCache);
    }

    public synchronized void setAttributesShadowItems(boolean attributesShadowItems) {
        this.attributesShadowItems = attributesShadowItems;
    }

    boolean isAttributesShadowItems() {
        return this.attributesShadowItems;
    }

    public TemplateModel wrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof TemplateModel) {
            return (TemplateModel)((Object)obj);
        }
        boolean asHash = false;
        boolean asSequence = false;
        if (obj instanceof PyJavaInstance) {
            Object jobj = ((PyJavaInstance)obj).__tojava__(class$java$lang$Object == null ? (class$java$lang$Object = JythonWrapper.class$("java.lang.Object")) : class$java$lang$Object);
            if (jobj instanceof TemplateModel) {
                return (TemplateModel)jobj;
            }
            if (jobj instanceof Map) {
                asHash = true;
            } else if (jobj instanceof Collection) {
                asSequence = true;
                if (!(jobj instanceof List)) {
                    obj = new ArrayList((Collection)jobj);
                }
            }
        }
        if (!(obj instanceof PyObject)) {
            obj = Py.java2py((Object)obj);
        }
        if (asHash || obj instanceof PyDictionary || obj instanceof PyStringMap) {
            return this.modelCache.getInstance(obj, JythonHashModel.FACTORY);
        }
        if (asSequence || obj instanceof PySequence) {
            return this.modelCache.getInstance(obj, JythonSequenceModel.FACTORY);
        }
        if (obj instanceof PyInteger || obj instanceof PyLong || obj instanceof PyFloat) {
            return this.modelCache.getInstance(obj, JythonNumberModel.FACTORY);
        }
        if (obj instanceof TemplateModelToJythonAdapter) {
            return ((TemplateModelToJythonAdapter)((Object)obj)).getModel();
        }
        if (obj instanceof PyNone) {
            return null;
        }
        return this.modelCache.getInstance(obj, JythonModel.FACTORY);
    }

    public PyObject unwrap(TemplateModel model) throws TemplateModelException {
        if (model instanceof JythonModel) {
            return ((JythonModel)model).object;
        }
        if (model instanceof WrapperTemplateModel) {
            return Py.java2py((Object)((WrapperTemplateModel)model).getWrappedObject());
        }
        if (model instanceof TemplateScalarModel) {
            return new PyString(((TemplateScalarModel)model).getAsString());
        }
        if (model instanceof TemplateNumberModel) {
            Number number = ((TemplateNumberModel)model).getAsNumber();
            if (number instanceof BigDecimal) {
                number = OptimizerUtil.optimizeNumberRepresentation(number);
            }
            if (number instanceof BigInteger) {
                return new PyLong((BigInteger)number);
            }
            return Py.java2py((Object)number);
        }
        return new TemplateModelToJythonAdapter(model);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TemplateModelToJythonAdapter
    extends PyObject {
        private final TemplateModel model;

        TemplateModelToJythonAdapter(TemplateModel model) {
            this.model = model;
        }

        TemplateModel getModel() {
            return this.model;
        }

        public PyObject __finditem__(PyObject key) {
            if (key instanceof PyInteger) {
                return this.__finditem__(((PyInteger)key).getValue());
            }
            return this.__finditem__(key.toString());
        }

        public PyObject __finditem__(String key) {
            if (this.model instanceof TemplateHashModel) {
                try {
                    return JythonWrapper.this.unwrap(((TemplateHashModel)this.model).get(key));
                }
                catch (TemplateModelException e) {
                    throw Py.JavaError((Throwable)e);
                }
            }
            throw Py.TypeError((String)("item lookup on non-hash model (" + this.getModelClass() + ")"));
        }

        public PyObject __finditem__(int index) {
            if (this.model instanceof TemplateSequenceModel) {
                try {
                    return JythonWrapper.this.unwrap(((TemplateSequenceModel)this.model).get(index));
                }
                catch (TemplateModelException e) {
                    throw Py.JavaError((Throwable)e);
                }
            }
            throw Py.TypeError((String)("item lookup on non-sequence model (" + this.getModelClass() + ")"));
        }

        public PyObject __call__(PyObject[] args, String[] keywords) {
            if (this.model instanceof TemplateMethodModel) {
                boolean isEx = this.model instanceof TemplateMethodModelEx;
                ArrayList<Object> list = new ArrayList<Object>(args.length);
                try {
                    for (int i = 0; i < args.length; ++i) {
                        list.add(isEx ? JythonWrapper.this.wrap(args[i]) : (args[i] == null ? null : args[i].toString()));
                    }
                    return JythonWrapper.this.unwrap((TemplateModel)((TemplateMethodModelEx)this.model).exec(list));
                }
                catch (TemplateModelException e) {
                    throw Py.JavaError((Throwable)e);
                }
            }
            throw Py.TypeError((String)("call of non-method model (" + this.getModelClass() + ")"));
        }

        public int __len__() {
            try {
                if (this.model instanceof TemplateSequenceModel) {
                    return ((TemplateSequenceModel)this.model).size();
                }
                if (this.model instanceof TemplateHashModelEx) {
                    return ((TemplateHashModelEx)this.model).size();
                }
            }
            catch (TemplateModelException e) {
                throw Py.JavaError((Throwable)e);
            }
            return 0;
        }

        public boolean __nonzero__() {
            try {
                if (this.model instanceof TemplateBooleanModel) {
                    return ((TemplateBooleanModel)this.model).getAsBoolean();
                }
                if (this.model instanceof TemplateSequenceModel) {
                    return ((TemplateSequenceModel)this.model).size() > 0;
                }
                if (this.model instanceof TemplateHashModel) {
                    return !((TemplateHashModelEx)this.model).isEmpty();
                }
            }
            catch (TemplateModelException e) {
                throw Py.JavaError((Throwable)e);
            }
            return false;
        }

        private String getModelClass() {
            return this.model == null ? "null" : this.model.getClass().getName();
        }
    }
}

