/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.sql.Connection;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.api.InstanceCache;
import net.sourceforge.jaxor.api.JaxorContext;
import net.sourceforge.jaxor.api.JaxorContextFactory;
import net.sourceforge.jaxor.api.JaxorTransaction;
import net.sourceforge.jaxor.api.QueryCache;
import net.sourceforge.jaxor.api.UnitOfWork;
import net.sourceforge.jaxor.db.SingleConnectionTransaction;
import net.sourceforge.jaxor.impl.InstanceCacheImpl;
import net.sourceforge.jaxor.impl.UnitOfWorkImpl;
import net.sourceforge.jaxor.util.MethodCache;

public class JaxorSession {
    private static final ThreadLocal SESSIONS = new ThreadLocal();
    private static JaxorContextFactory _defaultFactory = null;
    private final JaxorContext _context;

    public static void begin(UnitOfWork uow, JaxorTransaction factory) {
        JaxorSession.setSession(uow, new InstanceCacheImpl(), new MethodCache(), factory);
    }

    public static void commit() {
        JaxorSession.getJaxorContext().commit();
    }

    public static void end() {
        JaxorContext conn = JaxorSession.getJaxorContext();
        if (conn != null) {
            conn.end();
        }
        SESSIONS.set(null);
    }

    private static void setSession(UnitOfWork newWork, InstanceCache cache, QueryCache query, JaxorTransaction factory) {
        JaxorSession.setJaxorContext(new JaxorContextImpl(factory, cache, query, newWork));
    }

    public static void setJaxorContext(JaxorContext context) {
        SESSIONS.set(new JaxorSession(context));
    }

    public static JaxorContext getJaxorContext() {
        JaxorSession jaxorSession = JaxorSession.getJaxorSession();
        if (jaxorSession != null) {
            return jaxorSession._context;
        }
        return null;
    }

    private static JaxorSession getJaxorSession() {
        return (JaxorSession)SESSIONS.get();
    }

    public static void begin(Connection conn) {
        JaxorSession.begin(new SingleConnectionTransaction(conn));
    }

    public static void begin(JaxorTransaction factory) {
        JaxorSession.begin(new UnitOfWorkImpl(), factory);
    }

    public static void setDefaultFactory(JaxorContextFactory factory) {
        _defaultFactory = factory;
    }

    public static void begin() {
        if (_defaultFactory == null) {
            throw new NullPointerException("error:  no default connection factory specified");
        }
        JaxorSession.setJaxorContext(_defaultFactory.create());
    }

    private JaxorSession(JaxorContext context) {
        this._context = context;
    }
}

