/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.jaxor.MetaRow;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.api.EntityResultSet;
import net.sourceforge.jaxor.api.JaxorContext;
import net.sourceforge.jaxor.api.JaxorPreparedStatement;
import net.sourceforge.jaxor.impl.EntityResultSetImpl;
import net.sourceforge.jaxor.util.SystemException;

public class JaxorPreparedStatementImpl
implements JaxorPreparedStatement {
    private final MetaRow _metaRow;
    private final QueryParams _params;
    private final PreparedStatement _statement;
    private final JaxorContext _context;
    private final Connection _conn;

    public JaxorPreparedStatementImpl(MetaRow metaRow, QueryParams params, String sql, JaxorContext context) {
        this._metaRow = metaRow;
        this._params = params;
        this._conn = context.getConnection();
        try {
            this._statement = this._conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
        this._context = context;
    }

    public QueryParams getParams() {
        return this._params;
    }

    public PreparedStatement getStatement() {
        return this._statement;
    }

    public EntityResultSet executeAsEntityResultSet() {
        ResultSet rs = this.execute();
        return new EntityResultSetImpl(rs, this._context, this._metaRow);
    }

    public ResultSet execute() {
        this._params.setArgs(this._statement, this._context.getMapperRegistry());
        try {
            return this._statement.executeQuery();
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    public void close() {
        this.safeClose();
    }

    private void safeClose() {
        try {
            if (this._statement != null) {
                this._statement.close();
            }
            this._conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

