/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.jaxor.MetaRow;
import net.sourceforge.jaxor.db.ConnectionRegistry;
import net.sourceforge.jaxor.util.FileUtils;
import net.sourceforge.jaxor.util.SystemException;
import net.sourceforge.jaxor.util.Validation;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class ColumnChecker
extends MatchingTask {
    private File _srcdir;
    private String _driver;
    private String _url;
    private String _user;
    private String _password;
    private boolean _verbose;
    private boolean _capitalizeTable = true;

    public boolean isCapitalizeTable() {
        return this._capitalizeTable;
    }

    public void setCapitalizeTable(boolean capitalizeTable) {
        this._capitalizeTable = capitalizeTable;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public String getDriver() {
        return this._driver;
    }

    public void setDriver(String driver) {
        this._driver = driver;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public File getSrcdir() {
        return this._srcdir;
    }

    public void setSrcdir(File srcdir) {
        this._srcdir = srcdir;
    }

    private Connection createConnection() {
        return ConnectionRegistry.getConnection(this.getDriverClass()).create(this.getUrl(), this.getUser(), this.getPassword());
    }

    private Class getDriverClass() {
        try {
            return Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new SystemException(e);
        }
    }

    public void execute() {
        String[] files = this.getDirectoryScanner(this._srcdir).getIncludedFiles();
        this.log("Validating: " + files.length + " entities");
        Connection conn = this.createConnection();
        Validation val = new Validation();
        int i = 0;
        while (i < files.length) {
            MetaRow row = this.getMetaRowForClass(files[i]);
            val.add(row.validateColumns(conn, this._capitalizeTable));
            ++i;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (this._verbose) {
            this.log(val.toString());
        }
        if (val.hasErrors()) {
            throw new BuildException(val.toString());
        }
    }

    public MetaRow getMetaRowForClass(String src) {
        Class clzz = this.loadClass(src);
        try {
            return (MetaRow)clzz.newInstance();
        }
        catch (Exception e) {
            throw new SystemException("Failed to invoke method on " + clzz.getName(), (Throwable)e);
        }
    }

    private Class loadClass(String src) {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Class<?> clzz = null;
        try {
            clzz = loader.loadClass(FileUtils.toClassFileName(src));
        }
        catch (ClassNotFoundException e) {
            throw new SystemException(e);
        }
        return clzz;
    }
}

