/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.ftp.FtpClient;
import org.apache.commons.vfs.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.ftp.FtpRandomAccessContent;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

public class FtpFileObject
extends AbstractFileObject {
    private static final FTPFile[] EMPTY_FTP_FILE_ARRAY = new FTPFile[0];
    private final FtpFileSystem ftpFs;
    private final String relPath;
    private FTPFile fileInfo;
    private FTPFile[] children;
    private FileObject linkDestination;

    protected FtpFileObject(FileName name, FtpFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, fileSystem);
        this.ftpFs = fileSystem;
        String relPath = rootName.getRelativeName(name);
        this.relPath = ".".equals(relPath) ? rootName.getPath() : relPath;
    }

    private FTPFile getChildFile(String name, boolean flush) throws IOException {
        if (flush) {
            this.children = null;
        }
        this.doGetChildren();
        for (int i = 0; i < this.children.length; ++i) {
            FTPFile child = this.children[i];
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        FtpClient client = this.ftpFs.getClient();
        try {
            String key = FtpFileSystemConfigBuilder.getInstance().getEntryParser(this.getFileSystem().getFileSystemOptions());
            FTPFile[] tmpChildren = client.listFiles(key, this.relPath);
            if (tmpChildren == null || tmpChildren.length == 0) {
                this.children = EMPTY_FTP_FILE_ARRAY;
            } else {
                ArrayList<FTPFile> childList = new ArrayList<FTPFile>();
                for (int i = 0; i < tmpChildren.length; ++i) {
                    FTPFile child = tmpChildren[i];
                    if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
                    childList.add(child);
                }
                this.children = childList.toArray(new FTPFile[childList.size()]);
            }
        }
        finally {
            this.ftpFs.putClient(client);
        }
    }

    protected void doAttach() throws IOException {
        this.getInfo(false);
    }

    private void getInfo(boolean flush) throws IOException {
        FtpFileObject parent = (FtpFileObject)this.getParent();
        if (parent != null) {
            this.fileInfo = parent.getChildFile(this.getName().getBaseName(), flush);
        } else {
            this.fileInfo = new FTPFile();
            this.fileInfo.setType(1);
        }
    }

    protected void doDetach() {
        this.fileInfo = null;
        this.children = null;
    }

    protected void onChildrenChanged() {
        this.children = null;
    }

    protected void onChange() throws IOException {
        this.children = null;
        this.getInfo(true);
    }

    protected FileType doGetType() throws Exception {
        if (this.fileInfo == null) {
            return FileType.IMAGINARY;
        }
        if (this.fileInfo.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.fileInfo.isFile()) {
            return FileType.FILE;
        }
        if (this.fileInfo.isSymbolicLink()) {
            return this.getLinkDestination().getType();
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", this.getName());
    }

    private FileObject getLinkDestination() throws FileSystemException {
        if (this.linkDestination == null) {
            String path = this.fileInfo.getLink();
            FileName relativeTo = this.getName().getParent();
            if (relativeTo == null) {
                relativeTo = this.getName();
            }
            FileName linkDestinationName = relativeTo.resolveName(path);
            this.linkDestination = this.getFileSystem().resolveFile(linkDestinationName);
        }
        return this.linkDestination;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        if (this.fileInfo.isSymbolicLink()) {
            return this.getLinkDestination().getChildren();
        }
        return null;
    }

    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        String[] childNames = new String[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            FTPFile child = this.children[i];
            childNames[i] = child.getName();
        }
        return childNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        boolean ok;
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            ok = this.fileInfo.isDirectory() ? ftpClient.removeDirectory(this.relPath) : ftpClient.deleteFile(this.relPath);
        }
        finally {
            this.ftpFs.putClient(ftpClient);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/delete-file.error", this.getName());
        }
        this.fileInfo = null;
        this.children = EMPTY_FTP_FILE_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        boolean ok;
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            String oldName = this.getName().getPath();
            String newName = newfile.getName().getPath();
            ok = ftpClient.rename(oldName, newName);
        }
        finally {
            this.ftpFs.putClient(ftpClient);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/rename-file.error", new Object[]{this.getName().toString(), newfile});
        }
        this.fileInfo = null;
        this.children = EMPTY_FTP_FILE_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        boolean ok;
        FtpClient client = this.ftpFs.getClient();
        try {
            ok = client.makeDirectory(this.relPath);
        }
        finally {
            this.ftpFs.putClient(client);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/create-folder.error", this.getName());
        }
    }

    protected long doGetContentSize() throws Exception {
        if (this.fileInfo.isSymbolicLink()) {
            return this.getLinkDestination().getContent().getSize();
        }
        return this.fileInfo.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.fileInfo.isSymbolicLink()) {
            return this.getLinkDestination().getContent().getLastModifiedTime();
        }
        Calendar timestamp = this.fileInfo.getTimestamp();
        if (timestamp == null) {
            return 0L;
        }
        return timestamp.getTime().getTime();
    }

    protected void doSetLastModifiedTime(long modtime) throws Exception {
        if (this.fileInfo.isSymbolicLink()) {
            this.getLinkDestination().getContent().setLastModifiedTime(modtime);
        } else {
            Date d = new Date(modtime);
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(d);
            this.fileInfo.setTimestamp((Calendar)c);
        }
    }

    protected InputStream doGetInputStream() throws Exception {
        FtpClient client = this.ftpFs.getClient();
        InputStream instr = client.retrieveFileStream(this.relPath);
        return new FtpInputStream(client, instr);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new FtpRandomAccessContent(this, mode);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        FtpClient client = this.ftpFs.getClient();
        if (bAppend) {
            return new FtpOutputStream(client, client.appendFileStream(this.relPath));
        }
        return new FtpOutputStream(client, client.storeFileStream(this.relPath));
    }

    String getRelPath() {
        return this.relPath;
    }

    FtpInputStream getInputStream(long filePointer) throws IOException {
        FtpClient client = this.ftpFs.getClient();
        InputStream instr = client.retrieveFileStream(this.relPath, filePointer);
        return new FtpInputStream(client, instr);
    }

    private class FtpOutputStream
    extends MonitorOutputStream {
        private final FtpClient client;

        public FtpOutputStream(FtpClient client, OutputStream outstr) {
            super(outstr);
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-put.error", FtpFileObject.this.getName());
            }
        }
    }

    class FtpInputStream
    extends MonitorInputStream {
        private final FtpClient client;

        public FtpInputStream(FtpClient client, InputStream in) {
            super(in);
            this.client = client;
        }

        void abort() throws IOException {
            this.client.abort();
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-get.error", FtpFileObject.this.getName());
            }
        }
    }
}

