/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.LocalFileProvider;
import org.apache.commons.vfs.provider.local.GenericFileNameParser;
import org.apache.commons.vfs.provider.local.LocalFileName;
import org.apache.commons.vfs.provider.local.LocalFileNameParser;
import org.apache.commons.vfs.provider.local.LocalFileSystem;
import org.apache.commons.vfs.provider.local.WindowsFileNameParser;
import org.apache.commons.vfs.util.Os;

public class DefaultLocalFileProvider
extends AbstractOriginatingFileProvider
implements LocalFileProvider {
    public static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.SET_LAST_MODIFIED_FOLDER, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT, Capability.RANDOM_ACCESS_READ, Capability.RANDOM_ACCESS_WRITE));
    private final LocalFileNameParser parser = Os.isFamily(Os.OS_FAMILY_WINDOWS) ? new WindowsFileNameParser() : new GenericFileNameParser();

    public boolean isAbsoluteLocalName(String name) {
        return this.parser.isAbsoluteName(name);
    }

    public FileObject findLocalFile(String name) throws FileSystemException {
        StringBuffer uri = new StringBuffer(name.length() + 5);
        uri.append("file:");
        uri.append(name);
        FileName filename = this.parseUri(uri.toString(), false);
        return this.findFile(filename, null);
    }

    public FileObject findLocalFile(File file) throws FileSystemException {
        return this.findLocalFile(file.getAbsolutePath());
    }

    protected FileName parseUri(String uri, boolean uriEncoded) throws FileSystemException {
        return LocalFileName.parseUri(uri, uriEncoded, this.parser);
    }

    protected FileName parseUri(String uri) throws FileSystemException {
        return this.parseUri(uri, true);
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LocalFileName rootName = (LocalFileName)name;
        return new LocalFileSystem(rootName, rootName.getRootFile());
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

