/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.webdav.WebDavFileSystem;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.OptionsMethod;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.properties.ResourceTypeProperty;

public class WebdavFileObject
extends AbstractFileObject
implements FileObject {
    private final WebDavFileSystem fileSystem;
    private WebdavResource resource;
    private boolean redirectionResolved = false;
    private Set allowedMethods = null;

    protected WebdavFileObject(GenericFileName name, WebDavFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
    }

    protected void doAttach() throws Exception {
        if (this.resource == null) {
            this.setDavResource(null, true);
        }
    }

    protected void doDetach() throws Exception {
        if (this.resource != null) {
            this.redirectionResolved = false;
            this.allowedMethods = null;
            this.resource.close();
            this.resource = null;
        }
    }

    private void setDavResource(WebdavResource resource, boolean bCheckExists) throws Exception {
        ResourceTypeProperty resourceType;
        this.redirectionResolved = false;
        if (resource == null) {
            GenericFileName name = (GenericFileName)this.getName();
            HttpURL url = new HttpURL(name.getUserName(), name.getPassword(), name.getHostName(), name.getPort(), name.getPath());
            resource = new WebdavResource(this.fileSystem.getClient()){};
            resource.setHttpURL(url, 1, 1);
        }
        this.resource = resource;
        if (bCheckExists) {
            OptionsMethod optionsMethod = new OptionsMethod(this.getName().getPath());
            optionsMethod.setFollowRedirects(true);
            int status = this.fileSystem.getClient().executeMethod((HttpMethod)optionsMethod);
            if (status < 200 || status > 299) {
                if (status == 401 || status == 403) {
                    this.setAllowedMethods(null);
                    this.processParentDavResource();
                    return;
                }
                this.injectType(FileType.IMAGINARY);
                return;
            }
            this.redirectionResolved = true;
            resource.getHttpURL().setPath(optionsMethod.getPath());
            this.setAllowedMethods(optionsMethod.getAllowedMethods());
            boolean exists = false;
            Enumeration enumeration = optionsMethod.getAllowedMethods();
            while (enumeration.hasMoreElements()) {
                String method = (String)enumeration.nextElement();
                if (!method.equals("GET")) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.injectType(FileType.IMAGINARY);
                return;
            }
            try {
                resource.setProperties(4, 1);
            }
            catch (IOException e) {
                throw new FileSystemException(e);
            }
        }
        if ((resourceType = resource.getResourceType()).isCollection()) {
            this.injectType(FileType.FOLDER);
        } else {
            this.injectType(FileType.FILE);
        }
    }

    private void setAllowedMethods(Enumeration allowedMethods) {
        this.allowedMethods = new TreeSet();
        if (allowedMethods == null) {
            return;
        }
        while (allowedMethods.hasMoreElements()) {
            this.allowedMethods.add(allowedMethods.nextElement());
        }
    }

    private boolean hasAllowedMethods(String method) throws IOException {
        if (this.allowedMethods == null) {
            this.getAllowedMethods();
        }
        return this.allowedMethods.contains(method);
    }

    private void resolveRedirection() throws IOException, FileSystemException {
        if (this.redirectionResolved) {
            return;
        }
        OptionsMethod optionsMethod = new OptionsMethod(this.getName().getPath());
        optionsMethod.setFollowRedirects(true);
        int status = this.fileSystem.getClient().executeMethod((HttpMethod)optionsMethod);
        if (status >= 200 && status <= 299) {
            this.setAllowedMethods(optionsMethod.getAllowedMethods());
            this.resource.getHttpURL().setPath(optionsMethod.getPath());
            this.redirectionResolved = true;
        }
    }

    private void processParentDavResource() throws FileSystemException {
        WebdavFileObject parent = (WebdavFileObject)this.getParent();
        try {
            parent.doListChildrenResolved();
        }
        catch (Exception e) {
            throw new FileSystemException(e);
        }
    }

    protected FileType doGetType() throws Exception {
        throw new IllegalStateException("this should not happen");
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        this.doAttach();
        WebdavResource[] children = new WebdavResource[]{};
        try {
            children = this.resource.listWebdavResources();
        }
        catch (HttpException e) {
            if (e.getReasonCode() == 301 || e.getReasonCode() == 302) {
                this.resolveRedirection();
                children = this.resource.listWebdavResources();
            }
            throw e;
        }
        if (children == null) {
            throw new FileSystemException("vfs.provider.webdav/list-children.error", this.resource.getStatusMessage());
        }
        FileObject[] vfs = new WebdavFileObject[children.length];
        for (int i = 0; i < children.length; ++i) {
            WebdavResource dav = children[i];
            WebdavFileObject fo = (WebdavFileObject)this.getFileSystem().resolveFile(this.getName().resolveName(dav.getName(), NameScope.CHILD));
            fo.setDavResource(dav, false);
            vfs[i] = fo;
        }
        return vfs;
    }

    protected void doCreateFolder() throws Exception {
        this.resource.getHttpURL().setPath(this.getName().getPath() + '/');
        boolean ok = this.resource.mkcolMethod();
        if (!ok) {
            throw new FileSystemException("vfs.provider.webdav/create-collection.error", this.resource.getStatusMessage());
        }
        this.allowedMethods = null;
    }

    protected void doDelete() throws Exception {
        boolean ok = this.resource.deleteMethod(this.getName().getPath());
        if (!ok) {
            throw new FileSystemException("vfs.provider.webdav/delete-file.error", this.resource.getStatusMessage());
        }
        this.allowedMethods = null;
    }

    protected void doRename(FileObject newfile) throws Exception {
        boolean ok = this.resource.moveMethod(newfile.getName().getPath());
        if (!ok) {
            throw new FileSystemException("vfs.provider.webdav/rename-file.error", this.resource.getStatusMessage());
        }
        this.allowedMethods = null;
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.resource.getMethodData();
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new WebdavOutputStream();
    }

    protected long doGetContentSize() throws Exception {
        return this.resource.getGetContentLength();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.resource.getGetLastModified();
    }

    protected Map doGetAttributes() throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Enumeration e = this.resource.propfindMethod(0);
        while (e.hasMoreElements()) {
            XMLResponseMethodBase.Response response = (XMLResponseMethodBase.Response)e.nextElement();
            Enumeration properties = response.getProperties();
            while (properties.hasMoreElements()) {
                BaseProperty property = (BaseProperty)properties.nextElement();
                attributes.put(property.getLocalName(), property.getPropertyAsString());
            }
        }
        return attributes;
    }

    protected boolean doIsReadable() throws Exception {
        return this.hasAllowedMethods("GET");
    }

    protected boolean doIsWriteable() throws Exception {
        return this.hasAllowedMethods("POST");
    }

    private void getAllowedMethods() throws IOException {
        if (this.allowedMethods != null) {
            return;
        }
        OptionsMethod optionsMethod = new OptionsMethod(this.getName().getPath());
        optionsMethod.setFollowRedirects(true);
        int status = this.fileSystem.getClient().executeMethod((HttpMethod)optionsMethod);
        if (!(status >= 200 && status <= 299 || status != 401 && status != 403)) {
            this.setAllowedMethods(null);
            return;
        }
        this.setAllowedMethods(optionsMethod.getAllowedMethods());
    }

    private class WebdavOutputStream
    extends MonitorOutputStream {
        public WebdavOutputStream() {
            super(new ByteArrayOutputStream());
        }

        protected void onClose() throws IOException {
            ByteArrayOutputStream outstr = (ByteArrayOutputStream)this.out;
            WebdavFileObject.this.resource.getHttpURL().setPath(WebdavFileObject.this.getName().getPath());
            boolean ok = WebdavFileObject.this.resource.putMethod(outstr.toByteArray());
            if (!ok) {
                throw new FileSystemException("vfs.provider.webdav/write-file.error", WebdavFileObject.this.resource.getStatusMessage());
            }
            WebdavFileObject.this.allowedMethods = null;
        }
    }
}

