/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class ClassSize {
    public static final int refSize;
    private static final int objectOverhead = 2;
    private static final int booleanSize = 4;
    private static final int charSize = 4;
    private static final int shortSize = 4;
    private static final int intSize = 4;
    private static final int longSize = 8;
    private static final int floatSize = 4;
    private static final int doubleSize = 8;
    private static final int minObjectSize;
    private static boolean dummyCatalog;
    static boolean noGuess;
    static boolean unitTest;
    private static final int[] wildGuess;
    private static Hashtable catalog;

    public static void setDummyCatalog() {
        dummyCatalog = true;
    }

    public static int getRefSize() {
        return refSize;
    }

    public static int getIntSize() {
        return 4;
    }

    public static int[] getSizeCoefficients(Class clazz) {
        int[] nArray = new int[]{0, 2};
        while (clazz != null) {
            Field[] fieldArray = clazz.getDeclaredFields();
            if (fieldArray != null) {
                int n = 0;
                while (n < fieldArray.length) {
                    if (!Modifier.isStatic(fieldArray[n].getModifiers())) {
                        Class<?> clazz2 = fieldArray[n].getType();
                        if (clazz2.isArray() || !clazz2.isPrimitive()) {
                            nArray[1] = nArray[1] + 1;
                        } else {
                            String string = clazz2.getName();
                            if (string.equals("int") || string.equals("I")) {
                                nArray[0] = nArray[0] + 4;
                            } else if (string.equals("long") || string.equals("J")) {
                                nArray[0] = nArray[0] + 8;
                            } else if (string.equals("boolean") || string.equals("Z")) {
                                nArray[0] = nArray[0] + 4;
                            } else if (string.equals("short") || string.equals("S")) {
                                nArray[0] = nArray[0] + 4;
                            } else if (string.equals("byte") || string.equals("B")) {
                                nArray[0] = nArray[0] + 1;
                            } else if (string.equals("char") || string.equals("C")) {
                                nArray[0] = nArray[0] + 4;
                            } else if (string.equals("float") || string.equals("F")) {
                                nArray[0] = nArray[0] + 4;
                            } else if (string.equals("double") || string.equals("D")) {
                                nArray[0] = nArray[0] + 8;
                            } else {
                                nArray[1] = nArray[1] + 1;
                            }
                        }
                    }
                    ++n;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return nArray;
    }

    public static int estimateBaseFromCoefficients(int[] nArray) {
        int n = nArray[0] + nArray[1] * refSize;
        n = (n + 7) / 8;
        return (n *= 8) < minObjectSize ? minObjectSize : n;
    }

    public static int estimateBaseFromCatalog(Class clazz) {
        return ClassSize.estimateBaseFromCatalog(clazz, false);
    }

    private static int estimateBaseFromCatalog(Class clazz, boolean bl) {
        if (dummyCatalog) {
            return 0;
        }
        int[] nArray = (int[])catalog.get(clazz.getName());
        if (nArray == null) {
            try {
                nArray = ClassSize.getSizeCoefficients(clazz);
            }
            catch (Throwable throwable) {
                if (noGuess) {
                    return -2;
                }
                nArray = wildGuess;
            }
            if (bl) {
                catalog.put(clazz.getName(), nArray);
            }
        }
        return ClassSize.estimateBaseFromCoefficients(nArray);
    }

    public static int estimateAndCatalogBase(Class clazz) {
        return ClassSize.estimateBaseFromCatalog(clazz, true);
    }

    public static int estimateBase(Class clazz) {
        return ClassSize.estimateBaseFromCoefficients(ClassSize.getSizeCoefficients(clazz));
    }

    public static int estimateArrayOverhead() {
        return minObjectSize;
    }

    public static int estimateHashEntrySize() {
        return 2 + 3 * refSize;
    }

    public static int estimateMemoryUsage(String string) {
        if (string == null) {
            return 0;
        }
        return 2 * string.length();
    }

    static {
        dummyCatalog = false;
        noGuess = false;
        unitTest = false;
        wildGuess = new int[]{0, 16};
        try {
            catalog = (Hashtable)Class.forName("org.apache.derby.iapi.services.cache.ClassSizeCatalog").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        Object[] objectArray = new Object[10000];
        long l2 = runtime.totalMemory() - runtime.freeMemory() - l;
        int n = (int)((l2 + (long)(objectArray.length / 2)) / (long)objectArray.length);
        refSize = 4 > n ? 4 : n;
        minObjectSize = 4 * refSize;
    }
}

