/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.derby.iapi.services.context.ShutdownException;
import org.apache.derby.iapi.services.i18n.BundleFinder;
import org.apache.derby.iapi.services.info.JVMInfo;

public final class MessageService {
    private static final Locale EN = new Locale("en", "US");
    private static BundleFinder finder;

    public static ResourceBundle getBundleForLocale(Locale locale, String string) {
        try {
            return MessageService.getBundleWithEnDefault("org.apache.derby.loc.m" + MessageService.hashString50(string), locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static Object setFinder(BundleFinder bundleFinder) {
        finder = bundleFinder;
        return new MessageService().getClass();
    }

    public static String getTextMessage(String string) {
        return MessageService.getCompleteMessage(string, null);
    }

    public static String getTextMessage(String string, Object object) {
        return MessageService.getCompleteMessage(string, new Object[]{object});
    }

    public static String getTextMessage(String string, Object object, Object object2) {
        return MessageService.getCompleteMessage(string, new Object[]{object, object2});
    }

    public static String getTextMessage(String string, Object object, Object object2, Object object3) {
        return MessageService.getCompleteMessage(string, new Object[]{object, object2, object3});
    }

    public static String getTextMessage(String string, Object object, Object object2, Object object3, Object object4) {
        return MessageService.getCompleteMessage(string, new Object[]{object, object2, object3, object4});
    }

    public static String getCompleteMessage(String string, Object[] objectArray) {
        try {
            return MessageService.formatMessage(MessageService.getBundle(string), string, objectArray, true);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        return MessageService.formatMessage(MessageService.getBundleForLocale(EN, string), string, objectArray, false);
    }

    public static void getLocalizedMessage(int n, short s, String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, String string3, String string4, String string5, String string6, String[] stringArray, int[] nArray) {
        Object object;
        Object[] objectArray;
        String string7;
        int n8 = string6.indexOf("_");
        int n9 = string6.lastIndexOf("_");
        Locale locale = EN;
        if (n8 != -1) {
            string7 = string6.substring(0, n8);
            if (n9 == n8) {
                objectArray = string6.substring(n8 + 1);
                locale = new Locale(string7, (String)objectArray);
            } else {
                objectArray = string6.substring(n8 + 1, n9);
                object = string6.substring(n9 + 1);
                locale = new Locale(string7, (String)objectArray, (String)object);
            }
        }
        string7 = string4;
        objectArray = null;
        if (string != null && string.length() > 0) {
            object = string.toCharArray();
            int n10 = 0;
            int n11 = -1;
            int n12 = 0;
            while (n12 < ((char[])object).length) {
                if (object[n12] == '\u0014') {
                    ++n10;
                    n11 = n12;
                }
                ++n12;
            }
            if (n10 == 0) {
                string7 = new String((char[])object);
            } else {
                string7 = new String((char[])object, n11 + 1, ((char[])object).length - n11 - 1);
                objectArray = new Object[n10];
                n12 = 0;
                int n13 = 0;
                int n14 = 0;
                while (n14 < n11 + 1) {
                    if (n14 == n11 || object[n14] == '\u0014') {
                        objectArray[n13++] = new String((char[])object, n12, n14 - n12);
                        n12 = n14 + 1;
                    }
                    ++n14;
                }
            }
        }
        try {
            stringArray[0] = MessageService.formatMessage(MessageService.getBundleForLocale(locale, string7), string7, objectArray, true);
            nArray[0] = 0;
            return;
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        stringArray[0] = MessageService.formatMessage(MessageService.getBundleForLocale(EN, string7), string7, objectArray, false);
        nArray[0] = 0;
    }

    public static String getLocalizedMessage(Locale locale, String string, Object[] objectArray) {
        String string2 = null;
        try {
            string2 = MessageService.formatMessage(MessageService.getBundleForLocale(locale, string), string, objectArray, true);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        string2 = MessageService.formatMessage(MessageService.getBundleForLocale(EN, string), string, objectArray, false);
        return string2;
    }

    public static String getProperty(String string, String string2) {
        ResourceBundle resourceBundle = MessageService.getBundle(string);
        try {
            if (resourceBundle != null) {
                return resourceBundle.getString(string.concat(".").concat(string2));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static String formatMessage(ResourceBundle resourceBundle, String string, Object[] objectArray, boolean bl) {
        block16: {
            if (objectArray == null) {
                objectArray = new Object[]{};
            } else if (JVMInfo.JDK_ID == 1) {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] != null) {
                        objectArray[n] = objectArray[n].toString();
                    }
                    ++n;
                }
            }
            if (resourceBundle != null) {
                try {
                    string = resourceBundle.getString(string);
                    try {
                        return MessageFormat.format(string, objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    if (!bl) break block16;
                    throw missingResourceException;
                }
            }
        }
        if (string == null) {
            string = "UNKNOWN";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" : ");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(n2);
            stringBuffer.append("] ");
            if (objectArray[n2] == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(objectArray[n2].toString());
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static ResourceBundle getBundle(String string) {
        ResourceBundle resourceBundle = null;
        if (finder != null) {
            resourceBundle = finder.getBundle(string);
        }
        if (resourceBundle == null) {
            resourceBundle = MessageService.getBundleForLocale(Locale.getDefault(), string);
        }
        return resourceBundle;
    }

    public static ResourceBundle getBundleWithEnDefault(String string, Locale locale) {
        try {
            return ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return ResourceBundle.getBundle(string, EN);
        }
    }

    public static int hashString50(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 > 5) {
            n2 = 5;
        }
        int n3 = 0;
        while (n3 < n2) {
            n += string.charAt(n3);
            ++n3;
        }
        return n %= 50;
    }

    private MessageService() {
    }
}

