/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;

class DebugByteTeeOutputStream
extends FilterOutputStream {
    private AccessibleByteArrayOutputStream tee = new AccessibleByteArrayOutputStream(256);

    public void write(int n) throws IOException {
        this.out.write(n);
        this.tee.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.tee.write(byArray, n, n2);
    }

    void checkObject(Formatable formatable) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.tee.getInternalByteArray(), 0, this.tee.size());
        FormatIdInputStream formatIdInputStream = new FormatIdInputStream(byteArrayInputStream);
        Formatable formatable2 = null;
        try {
            formatable2 = (Formatable)formatIdInputStream.readObject();
            if (formatable2.equals(formatable)) {
                return;
            }
            if (formatable2.hashCode() == System.identityHashCode(formatable2) && formatable.hashCode() == System.identityHashCode(formatable)) {
                return;
            }
        }
        catch (Throwable throwable) {
            System.out.println("FormatableError:read error    : " + throwable.toString());
            System.out.println("FormatableError:class written : " + formatable.getClass());
            if (formatable2 == null) {
                System.out.println("FormatableError:read back as null");
            } else {
                System.out.println("FormatableError:class read    : " + formatable2.getClass());
            }
            System.out.println("FormatableError:write id      : " + FormatIdUtil.formatIdToString(formatable.getTypeFormatId()));
            if (formatable2 != null) {
                System.out.println("FormatableError:read id       : " + FormatIdUtil.formatIdToString(formatable2.getTypeFormatId()));
            }
            throwable.printStackTrace(System.out);
        }
    }

    DebugByteTeeOutputStream(OutputStream outputStream) {
        super(outputStream);
    }
}

