/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class IndexLister {
    private TableDescriptor tableDescriptor;
    private IndexRowGenerator[] indexRowGenerators;
    private long[] indexConglomerateNumbers;
    private String[] indexNames;
    private IndexRowGenerator[] distinctIndexRowGenerators;
    private long[] distinctIndexConglomerateNumbers;
    private String[] distinctIndexNames;

    public IndexRowGenerator[] getIndexRowGenerators() throws StandardException {
        if (this.indexRowGenerators == null) {
            this.getAllIndexes();
        }
        return this.indexRowGenerators;
    }

    public long[] getIndexConglomerateNumbers() throws StandardException {
        if (this.indexConglomerateNumbers == null) {
            this.getAllIndexes();
        }
        return this.indexConglomerateNumbers;
    }

    public String[] getIndexNames() throws StandardException {
        if (this.indexNames == null) {
            this.getAllIndexes();
        }
        return this.indexNames;
    }

    public IndexRowGenerator[] getDistinctIndexRowGenerators() throws StandardException {
        if (this.distinctIndexRowGenerators == null) {
            this.getAllIndexes();
        }
        return this.distinctIndexRowGenerators;
    }

    public long[] getDistinctIndexConglomerateNumbers() throws StandardException {
        if (this.distinctIndexConglomerateNumbers == null) {
            this.getAllIndexes();
        }
        return this.distinctIndexConglomerateNumbers;
    }

    public String[] getDistinctIndexNames() throws StandardException {
        if (this.indexNames == null) {
            this.getAllIndexes();
        }
        return this.indexNames;
    }

    private void getAllIndexes() throws StandardException {
        int n;
        int n2 = 0;
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
        long[] lArray = new long[conglomerateDescriptorArray.length - 1];
        int n3 = 0;
        int n4 = lArray.length - 1;
        int n5 = 0;
        while (n5 < conglomerateDescriptorArray.length) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n5];
            if (conglomerateDescriptor.isIndex()) {
                long l = conglomerateDescriptor.getConglomerateNumber();
                n = 0;
                while (n < n3) {
                    if (lArray[n] == l) {
                        lArray[n4--] = n5;
                        break;
                    }
                    ++n;
                }
                if (n == n3) {
                    lArray[n3++] = l;
                }
                ++n2;
            }
            ++n5;
        }
        this.indexRowGenerators = new IndexRowGenerator[n2];
        this.indexConglomerateNumbers = new long[n2];
        this.indexNames = new String[n2];
        this.distinctIndexRowGenerators = new IndexRowGenerator[n3];
        this.distinctIndexConglomerateNumbers = new long[n3];
        this.distinctIndexNames = new String[n3];
        n5 = lArray.length - 1;
        int n6 = 0;
        n = -1;
        int n7 = -1;
        while (n6 < conglomerateDescriptorArray.length) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n6];
            if (conglomerateDescriptor.isIndex()) {
                this.indexRowGenerators[++n] = conglomerateDescriptor.getIndexDescriptor();
                this.indexConglomerateNumbers[n] = conglomerateDescriptor.getConglomerateNumber();
                if (!conglomerateDescriptor.isConstraint()) {
                    this.indexNames[n] = conglomerateDescriptor.getConglomerateName();
                }
                if (n5 > n4 && n6 == (int)lArray[n5]) {
                    --n5;
                } else {
                    this.distinctIndexRowGenerators[++n7] = this.indexRowGenerators[n];
                    this.distinctIndexConglomerateNumbers[n7] = this.indexConglomerateNumbers[n];
                    this.distinctIndexNames[n7] = this.indexNames[n];
                }
            }
            ++n6;
        }
    }

    public IndexLister(TableDescriptor tableDescriptor) {
        this.tableDescriptor = tableDescriptor;
    }
}

