/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public class ViewDescriptor
extends TupleDescriptor
implements UniqueTupleDescriptor,
Dependent,
Provider {
    public static final int NO_CHECK_OPTION = 0;
    private int checkOption;
    private String viewName;
    private String viewText;
    private UUID uuid;
    private UUID compSchemaId;

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uUID) {
        this.uuid = uUID;
    }

    public String getViewText() {
        return this.viewText;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public int getCheckOptionType() {
        return this.checkOption;
    }

    public UUID getCompSchemaId() {
        return this.compSchemaId;
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(145);
    }

    public String getObjectName() {
        return this.viewName;
    }

    public UUID getObjectID() {
        return this.uuid;
    }

    public String getClassType() {
        return "View";
    }

    public boolean isValid() {
        return true;
    }

    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            default: {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y23.S", dependencyManager.getActionString(n), (Object)provider.getObjectName(), (Object)this.viewName);
            }
        }
    }

    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 35: 
            case 36: 
            case 38: {
                this.dropViewCascade(languageConnectionContext);
                break;
            }
        }
    }

    public void makeValid(LanguageConnectionContext languageConnectionContext) throws StandardException {
    }

    public String toString() {
        return "";
    }

    private void dropViewCascade(LanguageConnectionContext languageConnectionContext) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionCompile();
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.compSchemaId, transactionController);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.uuid);
        if (tableDescriptor == null) {
            return;
        }
        this.dropViewWork(dataDictionary, dependencyManager, languageConnectionContext, transactionController, schemaDescriptor, tableDescriptor, true);
        languageConnectionContext.getLastActivation().addWarning(StandardException.newWarning("01501", tableDescriptor.getName()));
    }

    public void dropViewWork(DataDictionary dataDictionary, DependencyManager dependencyManager, LanguageConnectionContext languageConnectionContext, TransactionController transactionController, SchemaDescriptor schemaDescriptor, TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        dataDictionary.dropAllColumnDescriptors(tableDescriptor.getUUID(), transactionController);
        dependencyManager.invalidateFor(tableDescriptor, bl ? 36 : 9, languageConnectionContext);
        dependencyManager.clearDependencies(languageConnectionContext, this);
        dataDictionary.dropViewDescriptor(this, transactionController);
        dataDictionary.dropTableDescriptor(tableDescriptor, schemaDescriptor, transactionController);
    }

    public ViewDescriptor(DataDictionary dataDictionary, UUID uUID, String string, String string2, int n, UUID uUID2) {
        super(dataDictionary);
        this.uuid = uUID;
        this.viewText = string2;
        this.viewName = string;
        this.checkOption = n;
        this.compSchemaId = uUID2;
    }
}

