/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.IOException;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;

class CodeChunk {
    static final short[] LOAD_VARIABLE = new short[]{21, 21, 21, 22, 23, 24, 21, 25};
    static final short[] LOAD_VARIABLE_FAST = new short[]{26, 26, 26, 30, 34, 38, 26, 42};
    static final short[] STORE_VARIABLE = new short[]{54, 54, 54, 55, 56, 57, 54, 58};
    static final short[] STORE_VARIABLE_FAST = new short[]{59, 59, 59, 63, 67, 71, 59, 75};
    static final short[] ARRAY_ACCESS = new short[]{51, 53, 46, 47, 48, 49, 52, 50};
    static final short[] ARRAY_STORE = new short[]{84, 86, 79, 80, 81, 82, 85, 83};
    static final short[] RETURN_OPCODE = new short[]{172, 172, 172, 173, 174, 175, 172, 176};
    static final short[][][] CAST_CONVERSION_INFO = new short[][][]{{{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, {{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, {{145, 0}, {147, 1}, {0, 2}, {133, 3}, {134, 4}, {135, 5}, {145, 6}, {-999, 7}}, {{136, 2}, {136, 2}, {136, 2}, {0, 3}, {137, 4}, {138, 5}, {136, 2}, {-999, 7}}, {{139, 2}, {139, 2}, {139, 2}, {140, 3}, {0, 4}, {141, 5}, {139, 2}, {-999, 7}}, {{142, 2}, {142, 2}, {142, 2}, {143, 3}, {144, 4}, {0, 5}, {142, 2}, {-999, 7}}, {{0, 0}, {0, 1}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 6}, {-999, 7}}, {{-999, 0}, {-999, 1}, {-999, 2}, {-999, 3}, {-999, 4}, {-999, 5}, {-999, 6}, {0, 7}}};
    private int codeOffset;
    private final ClassFormatOutput cout = new ClassFormatOutput();

    void addInstr(short s) {
        try {
            this.cout.putU1(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void addInstrU2(short s, int n) {
        try {
            this.cout.putU1(s);
            this.cout.putU2(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void addInstrU1(short s, int n) {
        try {
            this.cout.putU1(s);
            this.cout.putU1(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void addInstrCPE(short s, int n) {
        try {
            if (n < 256) {
                this.cout.putU1(s);
                this.cout.putU1(n);
            } else {
                this.cout.putU1((short)(s + 1));
                this.cout.putU2(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void addInstrWide(short s, int n) {
        try {
            if (n < 256) {
                this.cout.putU1(s);
                this.cout.putU1(n);
            } else {
                this.cout.putU1(196);
                this.cout.putU1(s);
                this.cout.putU2(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void addInstrU2U1U1(short s, int n, short s2, short s3) {
        try {
            this.cout.putU1(s);
            this.cout.putU2(n);
            this.cout.putU1(s2);
            this.cout.putU1(s3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void addChunk(CodeChunk codeChunk) {
        try {
            codeChunk.getCout().writeTo(this.cout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    ClassFormatOutput getCout() {
        return this.cout;
    }

    public int getRelativePC() {
        return this.cout.size() - this.codeOffset;
    }

    void fixLengths(int n, int n2, int n3) {
        byte[] byArray = this.cout.getData();
        byArray[0] = (byte)(n >> 8);
        byArray[1] = (byte)n;
        byArray[2] = (byte)(n2 >> 8);
        byArray[3] = (byte)n2;
        byArray[4] = (byte)(n3 >> 24);
        byArray[5] = (byte)(n3 >> 16);
        byArray[6] = (byte)(n3 >> 8);
        byArray[7] = (byte)n3;
    }

    void complete(ClassHolder classHolder, ClassMember classMember, int n, int n2) {
        int n3 = this.getRelativePC();
        ClassFormatOutput classFormatOutput = this.cout;
        try {
            classFormatOutput.putU2(0);
            classFormatOutput.putU2(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fixLengths(n, n2, n3);
        classMember.addAttribute("Code", classFormatOutput);
    }

    CodeChunk(boolean bl) {
        if (bl) {
            try {
                this.cout.putU2(0);
                this.cout.putU2(0);
                this.cout.putU4(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.codeOffset = 8;
        }
    }
}

