/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.services.reflect.JarFile;

final class JarFileJava2
extends JarFile {
    JarFile newJarFile(String[] stringArray) {
        return new JarFileJava2(stringArray);
    }

    void initialize(File file) throws IOException {
        java.util.jar.JarFile jarFile = new java.util.jar.JarFile(file);
        this.zip = jarFile;
    }

    ZipEntry getEntry(String string) {
        return ((java.util.jar.JarFile)this.zip).getJarEntry(string);
    }

    ZipInputStream getZipOnStream(InputStream inputStream) throws IOException {
        return new JarInputStream(inputStream);
    }

    ZipEntry getNextEntry(ZipInputStream zipInputStream) throws IOException {
        return ((JarInputStream)zipInputStream).getNextJarEntry();
    }

    byte[] readData(ZipEntry zipEntry, InputStream inputStream, String string) throws IOException {
        try {
            return super.readData(zipEntry, inputStream, string);
        }
        catch (SecurityException securityException) {
            throw this.handleException(securityException, string);
        }
    }

    Object[] getSigners(String string, ZipEntry zipEntry) throws IOException {
        try {
            Object[] objectArray = ((JarEntry)zipEntry).getCertificates();
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            int n = 0;
            while (n < objectArray.length) {
                Object object;
                if (!(objectArray[n] instanceof X509Certificate)) {
                    object = MessageService.getTextMessage("C001", string, this.getJarName());
                    throw new SecurityException((String)object);
                }
                object = (X509Certificate)objectArray[n];
                ((X509Certificate)object).checkValidity();
                ++n;
            }
            return objectArray;
        }
        catch (GeneralSecurityException generalSecurityException) {
            GeneralSecurityException generalSecurityException2 = generalSecurityException;
            throw this.handleException(generalSecurityException2, string);
        }
    }

    private SecurityException handleException(Exception exception, String string) {
        String string2 = MessageService.getTextMessage("C002", string, this.getJarName(), exception.getLocalizedMessage());
        return new SecurityException(string2);
    }

    JarFileJava2() {
    }

    JarFileJava2(String[] stringArray) {
        super(stringArray);
    }
}

