/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.CostEstimate;

public class CostEstimateImpl
implements CostEstimate {
    public double cost;
    public double rowCount;
    public double singleScanRowCount;

    public void setCost(double d, double d2, double d3) {
        this.cost = d;
        this.rowCount = d2;
        this.singleScanRowCount = d3;
    }

    public void setCost(CostEstimate costEstimate) {
        this.cost = costEstimate.getEstimatedCost();
        this.rowCount = costEstimate.rowCount();
        this.singleScanRowCount = costEstimate.singleScanRowCount();
    }

    public void setSingleScanRowCount(double d) {
        this.singleScanRowCount = d;
    }

    public double compare(CostEstimate costEstimate) {
        return this.cost - ((CostEstimateImpl)costEstimate).cost;
    }

    public CostEstimate add(CostEstimate costEstimate, CostEstimate costEstimate2) {
        CostEstimateImpl costEstimateImpl = (CostEstimateImpl)costEstimate;
        double d = this.cost + costEstimateImpl.cost;
        double d2 = this.rowCount + costEstimateImpl.rowCount;
        return this.setState(d, d2, (CostEstimateImpl)costEstimate2);
    }

    public CostEstimate multiply(double d, CostEstimate costEstimate) {
        double d2 = this.cost * d;
        double d3 = this.rowCount * d;
        return this.setState(d2, d3, (CostEstimateImpl)costEstimate);
    }

    public CostEstimate divide(double d, CostEstimate costEstimate) {
        double d2 = this.cost / d;
        double d3 = this.rowCount / d;
        return this.setState(d2, d3, (CostEstimateImpl)costEstimate);
    }

    public double rowCount() {
        return this.rowCount;
    }

    public double singleScanRowCount() {
        return this.singleScanRowCount;
    }

    public CostEstimate cloneMe() {
        return new CostEstimateImpl(this.cost, this.rowCount, this.singleScanRowCount);
    }

    public boolean isUninitialized() {
        return this.cost == Double.MAX_VALUE && this.rowCount == Double.MAX_VALUE && this.singleScanRowCount == Double.MAX_VALUE;
    }

    public double getEstimatedCost() {
        return this.cost;
    }

    public void setEstimatedCost(double d) {
        this.cost = d;
    }

    public long getEstimatedRowCount() {
        return (long)this.rowCount;
    }

    public void setEstimatedRowCount(long l) {
        this.rowCount = l;
        this.singleScanRowCount = l;
    }

    public CostEstimateImpl setState(double d, double d2, CostEstimateImpl costEstimateImpl) {
        if (costEstimateImpl == null) {
            costEstimateImpl = new CostEstimateImpl();
        }
        costEstimateImpl.cost = d;
        costEstimateImpl.rowCount = d2;
        return costEstimateImpl;
    }

    public CostEstimateImpl() {
    }

    public CostEstimateImpl(double d, double d2, double d3) {
        this.cost = d;
        this.rowCount = d2;
        this.singleScanRowCount = d3;
    }
}

