/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class GroupByList
extends OrderedColumnList {
    int numGroupingColsAdded = 0;

    public void addGroupByColumn(GroupByColumn groupByColumn) {
        this.addElement(groupByColumn);
    }

    public GroupByColumn getGroupByColumn(int n) {
        return (GroupByColumn)this.elementAt(n);
    }

    public void printSubNodes(int n) {
    }

    public int getNumNeedToAddGroupingCols() {
        return this.numGroupingColsAdded;
    }

    public void bindGroupByColumns(SelectNode selectNode, Vector vector) throws StandardException {
        FromList fromList = selectNode.getFromList();
        ResultColumnList resultColumnList = selectNode.getResultColumns();
        SubqueryList subqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        int n = 0;
        int n2 = this.size();
        if (n2 > 32677) {
            throw StandardException.newException("54004");
        }
        int n3 = 0;
        while (n3 < n2) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(n3);
            groupByColumn.bindExpression(fromList, subqueryList, vector);
            ++n3;
        }
        this.verifyUniqueGroupingColumns();
        n3 = 0;
        while (n3 < n2) {
            boolean bl = false;
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(n3);
            String string = groupByColumn.getColumnName();
            int n4 = groupByColumn.getTableNumber();
            ResultColumn resultColumn = groupByColumn.getSource();
            int n5 = resultColumnList.size();
            int n6 = 0;
            while (n6 < n5) {
                ColumnReference columnReference;
                ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(n6);
                if (resultColumn2.getExpression() instanceof ColumnReference && n4 == (columnReference = (ColumnReference)resultColumn2.getExpression()).getTableNumber() && resultColumn == columnReference.getSource()) {
                    groupByColumn.setColumnPosition(n6 + 1);
                    resultColumn2.markAsGroupingColumn();
                    bl = true;
                    break;
                }
                ++n6;
            }
            if (!bl) {
                ResultColumn resultColumn3 = (ResultColumn)this.getNodeFactory().getNode(80, groupByColumn.getColumnName(), groupByColumn.getColumnReference().getClone(), this.getContextManager());
                resultColumn3.setVirtualColumnId(resultColumnList.size() + 1);
                resultColumn3.markGenerated();
                resultColumn3.markAsGroupingColumn();
                resultColumnList.addElement(resultColumn3);
                groupByColumn.setColumnPosition(resultColumnList.size());
                ++n;
            }
            ++n3;
        }
        this.numGroupingColsAdded += n;
    }

    public void verifyUniqueGroupingColumns() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(n2);
            int n3 = groupByColumn.getTableNumber();
            ResultColumn resultColumn = groupByColumn.getSource();
            String string = groupByColumn.getColumnName();
            String string2 = groupByColumn.getColumnName();
            int n4 = n2 + 1;
            while (n4 < n) {
                GroupByColumn groupByColumn2 = (GroupByColumn)this.elementAt(n4);
                int n5 = groupByColumn2.getTableNumber();
                ResultColumn resultColumn2 = groupByColumn2.getSource();
                if (n3 == n5 && resultColumn == resultColumn2) {
                    throw StandardException.newException("42Y19", string2);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void addNewGroupingColumnsToRCL(SelectNode selectNode) throws StandardException {
        FromList fromList = selectNode.getFromList();
        int n = this.size();
        ResultColumnList resultColumnList = selectNode.getResultColumns();
        int n2 = 0;
        while (n2 < n) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(n2);
            if (groupByColumn.getColumnPosition() == -1) {
                VirtualColumnNode virtualColumnNode = (VirtualColumnNode)this.getNodeFactory().getNode(107, fromList.getFromTableByResultColumn(groupByColumn.getSource()), groupByColumn.getSource(), ReuseFactory.getInteger(resultColumnList.size() + 2), this.getContextManager());
                virtualColumnNode.setType(groupByColumn.getColumnReference().getTypeServices());
                ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, groupByColumn.getColumnName(), virtualColumnNode, this.getContextManager());
                resultColumn.setType(virtualColumnNode.getTypeServices());
                resultColumn.setVirtualColumnId(resultColumnList.size() + 2);
                resultColumnList.addElement(resultColumn);
                groupByColumn.setColumnPosition(resultColumnList.size());
            }
            ++n2;
        }
    }

    public GroupByColumn containsColumnReference(ColumnReference columnReference) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(n2);
            if (groupByColumn.getSource() == columnReference.getSource() && groupByColumn.getTableNumber() == columnReference.getTableNumber()) {
                return groupByColumn;
            }
            ++n2;
        }
        return null;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(n2);
            ValueNode valueNode = groupByColumn.getColumnReference().remapColumnReferencesToExpressions();
            groupByColumn.setColumnReference((ColumnReference)valueNode);
            ++n2;
        }
    }

    public String toString() {
        return "";
    }
}

